/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_box.h"

#include "list.h"

using namespace std;

/**
 * standard constructor
*/
GLGuiBox::GLGuiBox (GLGuiBoxType type)
{
  this->init();

  this->setType (type);
}


/**
 * standard deconstructor
*/
GLGuiBox::~GLGuiBox()
{
  delete this->children;
}

/**
 * initializes the GUI-element
 */
void GLGuiBox::init()
{
  this->setClassID(CL_GLGUI_BOX, "GLGuiBox");
  this->children = new tList<GLGuiWidget>;
}

void GLGuiBox::pack(GLGuiWidget* widget)
{
  if (widget == NULL)
    return;

  this->children->add(widget);
}


void GLGuiBox::unpack(GLGuiWidget* widget)
{
  if (widget == NULL)
  {
    delete this->children;
    this->children = new tList<GLGuiWidget>;
  }
  else
  {
    this->children->remove(widget);
  }
}

void GLGuiBox::showAll()
{
  tIterator<GLGuiWidget>* itC = this->children->getIterator();
  GLGuiWidget* enumC = itC->firstElement();
  while (enumC != NULL)
  {
    if (enumC->isA(CL_GLGUI_CONTAINER))
      static_cast<GLGuiContainer*>(enumC)->showAll();
    else
      enumC->show();
    enumC = itC->nextElement();
  }
  delete itC;

  this->show();

}

void GLGuiBox::hideAll()
{
  tIterator<GLGuiWidget>* itC = this->children->getIterator();
  GLGuiWidget* enumC = itC->firstElement();
  while (enumC != NULL)
  {
    if (enumC->isA(CL_GLGUI_CONTAINER))
      static_cast<GLGuiContainer*>(enumC)->showAll();
    else
      enumC->hide();
    enumC = itC->nextElement();
  }
  delete itC;

  this->hide();
}


/**
 * draws the GLGuiBox
 */
void GLGuiBox::draw()
{

}
