/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_widget.h"

using namespace std;

/**
 * standard constructor
*/
GLGuiWidget::GLGuiWidget ( ) : Element2D(NULL)
{
  this->init();
  this->setVisibility(GLGUI_WIDGET_DEFAULT_VISIBLE);
}


/**
 * standard deconstructor
*/
GLGuiWidget::~GLGuiWidget()
{

}


bool GLGuiWidget::focusOverWidget(float x, float y)
{
  if (this->getAbsCoor2D().x < x && this->getAbsCoor2D().x+ this->getSizeX2D() > x &&
      this->getAbsCoor2D().y < y && this->getAbsCoor2D().y+ this->getSizeX2D() > y)
    return true;
  else
    return false;
}


/**
 * initializes the GUI-element
 */
void GLGuiWidget::init()
{
  this->setClassID(CL_GLGUI_WIDGET, "GLGuiWidget");

  this->focusable = true;
  this->clickable = true;

  this->backMat = NULL;
  this->backModel = 0;
  this->frontMat = NULL;
  this->frontModel = 0;
}
