/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...

   Benjamin Grauer: added SDL_ResizeEvent resize (for the GraphicsEngine)
*/

/*!
 * @file event.h
 * an abstract event
 */

#ifndef _EVENT_H
#define _EVENT_H

#include "sdlincl.h"

//! An abstract event class
class Event {

 public:
  Event();

  int      offset;                      //!< offset in the event type array
  int      type;                        //!< the type field
  bool     bPressed;                    //!< is true, if the button/mouse was pressed, false if released

  Uint16   x;                           //!< x coordinate
  Uint16   y;                           //!< y coordinate
  Sint16   xRel;                        //!< relative x movement to last point
  Sint16   yRel;                        //!< relative y movement to last point

  SDL_ResizeEvent resize;
};

#endif /* _EVENT_H */
