/*!
 * @file glgui_widget.h
 * The gl_widget of the openglGUI
 */

#ifndef _GLGUI_WIDGET_H
#define _GLGUI_WIDGET_H

#include "element_2d.h"
#include "glincl.h"
#include "event.h"

// FORWARD DECLARATION
class Material;
class Signal; //!< @todo create this!!

typedef enum
{
  GLGuiSignal_click     = 0,
  GLGuiSignal_release   = 1,
  GLGuiSignal_rollOn    = 2,
  GLGuiSignal_rollOff   = 3,
  GLGuiSignal_open      = 4,
  GLGuiSignal_close     = 5,
  GLGuiSignal_destroy   = 6,

  GLGuiSignalCount      = 7,
} GLGuiSignalType;

//! if the Element should be visible by default.
#define GLGUI_WIDGET_DEFAULT_VISIBLE       false

//! This is widget part of the openglGUI class
/**
 * A widget is the main class of all the elements of th GUI.
 */
class GLGuiWidget : public Element2D {
  public:
    GLGuiWidget();
    virtual ~GLGuiWidget();

    void init();

    void show();
    void hide();

    void connectSignal(GLGuiSignalType signalType, Signal* signal);
    void disconnectSignal(GLGuiSignalType);
    bool focusOverWidget(float x, float y);

    // if something was clickt on the GUI-widget.
    virtual void click(const Event& event) {};
    virtual void release(const Event& event) {};

    virtual void receiveFocus() {};
    virtual void removeFocus() {};

    virtual void update() = 0;

  protected:
    Material*             backMat;
    GLuint                backModel;

    Material*             frontMat;
    GLuint                frontModel;

    Signal*               widgetSignals[GLGuiSignalCount];

  private:
    bool                  focusable;        //!< If this widget can receive focus.
    bool                  clickable;        //!< if this widget can be clicked upon.
};

#endif /* _GLGUI_WIDGET_H */
