/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*!
  @file t_stack.h
  @brief Contains the tStack Class that handles stacks of classes.
  this class creates a Array of a semi-Dynamic length.
  beware, that after finalizing the array may not be resized again.
*/

#ifndef _T_STACK_H
#define _T_STACK_H

using namespace std;

//! Stack Class that handles dynamic-type Stacks.
template<class T>
     class tStack
{
  public:
    tStack();
    ~tStack();

    void push(T entry);
    T pop();
    T getTop();
    /** @returns the Size of the Stack (0 if empty) */
    unsigned int getSize() { return this->entryCount; };

    void debug() const ;

  private:
    //! One entry of the Stack
    struct tStackEntry
    {
      T              value;          //!< The value of this Entry.
      tStackEntry*   next;           //!< Pointer to the Next entry.
    };


    unsigned int     entryCount;      //!< The count of Entries in this Array.
    tStackEntry*     topEntry;      //!< Pointer to the first Entry of this Array
};

/**
 * creates and initializes a Stack
 */
template<class T>
    tStack<T>::tStack()
{
  this->topEntry = NULL;
  this->entryCount = 0;
}

/**
 * delocates alocated memory from a Stack.
 * This does not delete the entries of the Stack
 */
template<class T>
    tStack<T>::~tStack()
{
  tStackEntry* delEntry;
  while (this->topEntry != NULL)
  {
    delEntry = this->topEntry;
    this->topEntry = topEntry->next;
    delete delEntry;
  }
}


/**
 * pushes one Entry into the Stack.
 * @param entry the Entry to push into the Stack
 */
template<class T>
    void tStack<T>::push(T entry)
{
  tStackEntry* newEntry = new tStackEntry;
  newEntry->value = entry;
  newEntry->next = this->topEntry;
  this->topEntry = newEntry;

  this->entryCount++;
}


/**
 * pops up the topmost enrty of the Stack, and moves the pointer to the next Stack-entry.
 * @returns the top-most enrty.
 */
template<class T>
    T tStack<T>::pop()
{
  if (this->topEntry == NULL)
    return 0;

  tStackEntry* retEntry = this->topEntry;
  T retVal = retEntry->value;
  this->topEntry = this->topEntry->next;
  delete retEntry;
  this->entryCount--;
  return retVal;
}

/**
 * @returns the topMost entry of the Stack
 */
template<class T>
    T tStack<T>::getTop()
{
  if (this->topEntry != NULL)
    return this->topEntry->value;
  else
    return NULL;
}

#endif /* _T_STACK_H */
