/*!
 * @file proto_singleton.h
 * @brief Definition of the ... singleton Class
*/

#ifndef _GLGUI_HANDLER_H
#define _GLGUI_HANDLER_H

#include "event_listener.h"

// FORWARD DEFINITION

//! A default singleton class.
class GLGuiHandler : public EventListener {

 public:
  virtual ~GLGuiHandler(void);
  /** @returns a Pointer to the only object of this Class */
  inline static GLGuiHandler* getInstance(void) { if (!singletonRef) singletonRef = new GLGuiHandler();  return singletonRef; };

  void activate();
  void deactivate();


  virtual void process(const Event &event);

 private:
  GLGuiHandler(void);
  static GLGuiHandler* singletonRef;


  bool                 isActive;
};

#endif /* _GLGUI_HANDLER_H */
