/*!
* @file glgui_widget.h
* The gl_widget of the openglGUI
*/

#ifndef _GLGUI_WIDGET_H
#define _GLGUI_WIDGET_H

#include "element_2d.h"
#include "glincl.h"

// FORWARD DECLARATION
class Material;

//! This is widget part of the openglGUI class
/**
* A widget is the main class of all the elements of th GUI.
*/
class GLGuiWidget : public Element2D {
  public:
    GLGuiWidget();
    virtual ~GLGuiWidget();

    void init();

    void show();
    void hide();


    virtual void update() = 0;

  protected:
    Material*             backGround;
    GLuint                renderModel;

  private:
    bool                  managed;          //!< if this GUI-element should be managed. true means it gets deleted with the deletion of it's parent.
    bool                  focusable;        //!< If it can receive focus.
    bool                  clickable;        //!< if it can be clicked upon.
};

#endif /* _GLGUI_WIDGET_H */
