/*!
 * @file proto_singleton.h
 * @brief Definition of the ... singleton Class
*/

#ifndef _GLGUI_HANDLER_H
#define _GLGUI_HANDLER_H

#include "base_object.h"

// FORWARD DEFINITION

//! A default singleton class.
class GLGuiHandler : public BaseObject {

 public:
  virtual ~GLGuiHandler(void);
  /** @returns a Pointer to the only object of this Class */
  inline static GLGuiHandler* getInstance(void) { if (!singletonRef) singletonRef = new GLGuiHandler();  return singletonRef; };

 private:
  GLGuiHandler(void);
  static GLGuiHandler* singletonRef;
};

#endif /* _GLGUI_HANDLER_H */
