/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "glgui_handler.h"

using namespace std;

/**
 * standard constructor
 */
GLGuiHandler::GLGuiHandler ()
{
   this->setClassID(CL_GLGUI_HANDLER, "GLGuiHandler");
   this->setName("GLGuiHandler");

   /* If you make a new class, what is most probably the case when you write this file
      don't forget to:
       1. Add the new file new_class.cc to the ./src/Makefile.am
       2. Add the class identifier to ./src/class_id.h eg. CL_NEW_CLASS
   !!!!!!!!!! IMPORTANT FOR SINGLETON !!!!!!!!!!!!!!!!
        3. SingleTon MUST be CL_NEW_CLASS = 0x00000fxx

      Advanced Topics:
      - if you want to let your object be managed via the ObjectManager make sure to read
        the object_manager.h header comments. You will use this most certanly only if you
        make many objects of your class, like a weapon bullet.
   */
}

/**
 *  the singleton reference to this class
 */
GLGuiHandler* GLGuiHandler::singletonRef = NULL;

/**
   @brief standard deconstructor
 */
GLGuiHandler::~GLGuiHandler ()
{
  GLGuiHandler::singletonRef = NULL;
}
