/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_container.h"

#include "list.h"


using namespace std;

/**
 * standard constructor
*/
GLGuiContainer::GLGuiContainer ()
{
  this->init();
  this->children = new tList<GLGuiWidget>;
}


/**
 * standard deconstructor
*/
GLGuiContainer::~GLGuiContainer()
{
  delete this->children;
}

/**
 * initializes the GUI-element
 */
void GLGuiContainer::init()
{
  this->setClassID(CL_GLGUI_CONTAINER, "GLGuiContainer");

}

void GLGuiContainer::showAll()
{

  tIterator<GLGuiWidget>* itC = this->children->getIterator();
  GLGuiWidget* enumC = itC->firstElement();
  while (enumC != NULL)
  {
    if (enumC->isA(CL_GLGUI_CONTAINER))
      static_cast<GLGuiContainer*>(enumC)->showAll();
    else
     enumC->show();
    enumC = itC->nextElement();
  }
  delete itC;

  this->show();

}

void GLGuiContainer::hideAll()
{

}


/**
 * draws the GLGuiContainer
 */
void GLGuiContainer::draw()
{

}
