/*!
 * @file text_engine.h
 *  Definition of textEngine, the Font and the Text
 *
 * Text is the text outputed.
 * Font is a class that loads a certain ttf-file with a specific height into memory
 * TextEngine is used to manage the all the different Fonts that might be included
 *
 *   for more information see the specific classes.
 *
 *  !! IMPORTANT !! When using ttf fonts clear the license issues prior to
 * adding them to orxonox. This is really important, because we do not want
 * to offend anyone.
 */

#ifndef _TEXT_ENGINE_H
#define _TEXT_ENGINE_H

#include "base_object.h"

#include "vector.h"

// FORWARD DECLARATION
class PNode;
class Font;
class Text;

//! A singleton Class that operates as a Handler initializing FONTS.
class TextEngine : public BaseObject
{
 public:
  virtual ~TextEngine();
  /** @returns a Pointer to the only object of this Class */
  inline static TextEngine* getInstance() { if (!singletonRef) singletonRef = new TextEngine();  return singletonRef; };

  void debug() const;

 private:
  TextEngine();
  static TextEngine* singletonRef;

  // general
  static void enableFonts();
  static void disableFonts();
  static bool checkVersion();
};

#endif /* _TEXT_ENGINE_H */
