/*!
 * @file shell_completion.h
 * @brief The Shell Completion Tasks
*/

#ifndef _SHELL_COMPLETION_H
#define _SHELL_COMPLETION_H

// FORWARD DECLARATION
class BaseObject;
class ShellInput;
template<class T> class tList;
#ifndef NULL
#define NULL 0            //!< a pointer to NULL
#endif

//! an enumerator for different types the Shell can complete.
typedef enum {
  SHELLC_NONE        = 0,
  SHELLC_CLASS       = 1,
  SHELLC_OBJECT      = 2,
  SHELLC_FUNCTION    = 4,
  SHELLC_ALIAS       = 8,
} SHELLC_TYPE;

//! A struct for ShellElements (these are used as containers to identify an Input for what it is)
struct ShellC_Element{
  const char*     name;     //!< the Name of the Element to be completed.
  SHELLC_TYPE     type;     //!< the type of the Element
};

//! A class for ...
class ShellCompletion {

 public:
  ShellCompletion(ShellInput* input = NULL);
  virtual ~ShellCompletion();

  bool autoComplete(ShellInput* input = NULL);
  bool classComplete(const char* classBegin);
//  long classMatch(const char* input, unsigned int* length);
  bool objectComplete(const char* objectBegin, long classID);
//  bool objectMatch(const char* objectBegin, long classID, unsigned int* length);
  bool functionComplete(const char* functionBegin, const char* className);
//  bool functionMatch(const char* functionBegin, long classID, unsigned int* length);
  bool aliasComplete(const char* aliasBegin);

  bool generalComplete(const char* begin, const char* displayAs = "%s", const char* addBack = NULL, const char* addFront = NULL);

  bool addToCompleteList(const tList<const char>* inputList, const char* completionBegin, SHELLC_TYPE type);
  bool addToCompleteList(const tList<BaseObject>* inputList, const char* completionBegin, SHELLC_TYPE type);
  void emptyCompletionList();

  static const char* ShellCompletion::typeToString(SHELLC_TYPE type);

 private:
   tList<ShellC_Element>*   completionList;          //!< A list of completions, that are io.
   ShellInput*              input;                   //!< the input this completion works on.
};

#endif /* _SHELL_COMPLETION_H */
