/*!
 * @file ogg_player.h
 * Ogg-Player definition
 */


#ifndef _OGG_PLAYER_H
#define _OGG_PLAYER_H

using namespace std;

#include "base_object.h"

#include "alincl.h"
#include <ogg/ogg.h>
#include <vorbis/vorbisfile.h>

struct File;



#define BUFFER_SIZE (4096 * 4)


// the definition of a Ogg-Player
class OggPlayer : public BaseObject
  {
  public:
    OggPlayer(const char* fileName = NULL);

    void open(const char* fileName);
    void release();
    void display();
    bool playback();
    bool playing();
    bool update();

  protected:

    bool stream(ALuint buffer);
    void empty();
    void check();
    const char* errorString(int code);

  private:

    FILE*               oggFile;              //!< general file-handler, to open the sound-file
    OggVorbis_File      oggStream;            //!< The stream this Ogg-player is playing back
    vorbis_info*        vorbisInfo;           //!< The information held in the opened ogg-file
    vorbis_comment*     vorbisComment;        //!< Comments about the ogg-file

    ALuint              buffers[2];           //!< buffers that handle sequentially buffering of the audio
    ALuint              source;               //!< The source we play back on
    ALenum              format;               //!< The format we play back
  };


#endif /* _OGG_PLAYER_H */
