/*!
 * @file bv_tree.h
  *  Definition of a bounding volume tree

*/

#ifndef _BV_TREE_H
#define _BV_TREE_H


#include "base_object.h"
#include "abstract_model.h"

// FORWARD DEFINITION
class BoundingVolume;
class BVTreeNode;
class PNode;
class WorldEntity;

typedef enum DrawMode
{
  DRAW_ALL               = 1<<0,
  DRAW_SINGLE            = 1<<1,

  DRAW_SEPARATING_PLANE  = 1<<2,
  DRAW_BV_AXIS           = 1<<3,
  DRAW_BV_BLENDED        = 1<<4,
  DRAW_BV_POLYGON        = 1<<5,
  DRAW_MODEL             = 1<<6,
  DRAW_POINTS            = 1<<7
};


//! A class that represents a bounding volume tree
class BVTree : public BaseObject {

 public:
  BVTree();
  virtual ~BVTree();

  virtual void spawnBVTree(int depth, sVec3D *verticesList, const int length) = 0;
  virtual void flushTree() = 0;

  virtual void collideWith(BVTree* tree, WorldEntity* nodeA, WorldEntity* nodeB) = 0;
  virtual void collideWith(WorldEntity* entity1, WorldEntity* entity2) = 0;

  virtual void drawBV(int depth, int drawMode) const = 0;


 protected:
  int numberOfVertices;

 private:


};

#endif /* _BV_TREE_H */
