/*!
 * @file bounding_volume.h
  *  Definition of a bounding volume for collision detection algorithms

 */

#ifndef _BOUNDING_VOLUME_H
#define _BOUNDING_VOLUME_H

#include "base_object.h"
#include "abstract_model.h"

class Vector;
template<class T> class tList;


//! An abstract class representing a bounding volume
class BoundingVolume : public BaseObject {

  public:
    BoundingVolume();
    virtual ~BoundingVolume();

    inline const Vector* getCenter() const { return this->center; }

    sVec3D* getVertices() const { return this->vertices; }
    virtual void mergeWith(const BoundingVolume &bv) = 0;

    virtual void drawBV(int currentDepth, int drawMode) const = 0;



  public:
    Vector*             center;                     //!< Center point of box

    sVec3D*             vertices;                   //!< if CD_STORE_VERTICES enabled, this is the place, where the vert. will be sotred
    int                 numOfVertices;              //!< number of vertices in the vertices buffer
    bool                bOrigVertices;              //!< is true if the vertices pointer points to the original model data - only important for deleting
};

#endif /* _BOUNDING_VOLUME_H */
