/*!
 * @file shell_input.h
 * @brief Definition of ...
 * @todo AutoCompletion should print nice output
 * @todo move up and down in Buffer
 * @todo display old shell Commands
*/

#ifndef _SHELL_INPUT_H
#define _SHELL_INPUT_H

#include "text_engine.h"
#include "event_listener.h"

// FORWARD DECLARATION
template<class T> class tList;
template<class T> class tIterator;
class ShellCompletion;


//! A class for ...
class ShellInput : public Text,  public EventListener {

 public:
  ShellInput();
  virtual ~ShellInput();

  /** @returns the inputLine */
  const char* getInput() const { return this->inputLine; };

  // InputLine
  void flush();
  void setInputText(const char* text);
  void addCharacter(char character);
  void addCharacters(const char* characters);
  void removeCharacters(unsigned int characterCount = 1);
  void setRepeatDelay(float repeatDelay, float repeatRate);
  bool executeCommand();

  void historyMoveUp();
  void historyMoveDown();

  void help(const char* className = "", const char* function = "");

  virtual void tick(float dt);
  virtual void process(const Event &event);

 private:
    // HANDLING TEXT INPUT
   ShellCompletion*         completion;             //!< The Completion Interface.


   char*                    inputLine;              //!< the Char-Array of the Buffer @todo not needed anymore
   float                    repeatRate;             //!< The Repeat-Delay.
   float                    repeatDelay;            //!< The delay of the first Character of a given Character.
   float                    delayed;                //!< how much of the delay is remaining.
   int                      pressedKey;             //!< the pressed key that will be repeated.

   tList<char>*             history;                //!< The history of given commands.
   tIterator<char>*         historyIT;
   unsigned int             historyLength;          //!< The maximum length of the InputHistory.
   bool                     historyScrolling;       //!< true if we are scrolling through the history.
};

#endif /* _SHELL_INPUT_H */
