/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include "gui_keys.h"

#include <string.h>

/**
 *  Creates an Keyboard-Frame
*/
GuiKeys::GuiKeys()
{
  Frame* keysFrame;      //!< The Frame that holds the keyOptions.

  keysFrame = new Frame("Keyboard-Options:");
  {
    Box* keysBox0;          //!< The Frame that holds the keyOptions.

    //  keysFrame->setGroupName("Keyboard");
    keysBox0 = new Box('v');
    {
      Box* keysBox1;
      MiscKeys* misc;            //!< The Misc Keys

      keysBox1 = new Box('h');
      {
        PlayerKeys* player1;       //!< The first Player's keys.
        PlayerKeys* player2;       //!< The seconds Player's keys.

        player1 = new PlayerKeys(CONFIG_SECTION_PLAYER "1");
        player2 = new PlayerKeys(CONFIG_SECTION_PLAYER "2");

        keysBox1->fill(player1->getOpenButton());
        keysBox1->fill(player2->getOpenButton());
      }
      keysBox0->fill(keysBox1);

      misc = new MiscKeys();
      keysBox0->fill(misc->getOpenButton());
    }
    keysFrame->fill(keysBox0);
  }

  // setting up the Input Windows that receives keystrokes.
  this->inputWindow = new Window("inputWindow");
  this->inputButton = new Button("test");
#ifdef HAVE_GTK2
  this->inputWindow->connectSignal("destroy",  Widget::doNothingSignal);
  this->inputWindow->connectSignal("delete_event", Widget::doNothingSignal);
#endif /* HAVE_GTK2 */
  this->inputWindow->fill(inputButton);

  this->setMainWidget(keysFrame);
}

/**
 *  Destructs the Keys-stuff
*/
GuiKeys::~GuiKeys()
{
  // nothing to do here.
}


Window* GuiKeys::inputWindow = NULL;
Button* GuiKeys::inputButton = NULL;
long GuiKeys::keySignal = 0;

////////////
/* PLAYER */
////////////
/**
 *  Creates new inputs for a player
 * @param player the name of the Player
*/
PlayerKeys::PlayerKeys(char* player)
{
  Window* pKeyWindow;     //!< The Window for a new Key-setting.

  char* windowName = new char[strlen(player)+12];
  strcpy(windowName, "KeySets: ");
  strcat(windowName, player);
  pKeyWindow = new Window(windowName);
  {
    Frame* pKeyFrame;       //!< The Frame for a new Key-setting.

    pKeyFrame = new Frame(windowName);
    {
      Box* pKeysBox;          //!< The Box that holds the Key-settings.
      pKeysBox = new Box('v');
      {
        Button* closeButton;    //!< The CloseButton for this key-settings.

        pKeysBox->setGroupName(player);
        pKeysBox->fill(addKey(CONFIG_NAME_PLAYER_UP, "UP"));
        pKeysBox->fill(addKey(CONFIG_NAME_PLAYER_DOWN, "DOWN"));
        pKeysBox->fill(addKey(CONFIG_NAME_PLAYER_LEFT, "LEFT"));
        pKeysBox->fill(addKey(CONFIG_NAME_PLAYER_RIGHT, "RIGHT"));
        pKeysBox->fill(addKey(CONFIG_NAME_PLAYER_FIRE, "SPACE"));
        pKeysBox->fill(addKey(CONFIG_NAME_PLAYER_NEXT_WEAPON, "m"));
        pKeysBox->fill(addKey(CONFIG_NAME_PLAYER_PREV_WEAPON, "n"));
        closeButton = new Button("close");
#ifdef HAVE_GTK2
        closeButton->connectSignal("button_press_event", pKeyWindow, Window::windowClose);
#endif /* HAVE_GTK2 */

        pKeysBox->fill(closeButton);
      }
      pKeyFrame->fill(pKeysBox);
    }
    pKeyWindow->fill(pKeyFrame);
  }
  delete[] windowName;
  Window::addWindow(pKeyWindow);
#ifdef HAVE_GTK2
  pKeyWindow->connectSignal("destroy", pKeyWindow, Window::windowClose);
  pKeyWindow->connectSignal("delete_event", pKeyWindow, Window::windowClose);
#endif /* HAVE_GTK2 */

  this->openButton = new Button(player);
#ifdef HAVE_GTK2
  this->openButton->connectSignal("button_press_event", pKeyWindow, Window::windowOpen);
#endif /* HAVE_GTK2 */
}

/**
 * @returns the OpenButton of a Player
*/
Button* PlayerKeys::getOpenButton()
{
  return this->openButton;
}

//////////////////
/* MISC_OPTIONS */
//////////////////
/**
 *  Creates new inputs for a misc
 * @param player the name of the Misc
*/
MiscKeys::MiscKeys()
{
  Window* keyWindow;     //!< The Window for a new Key-setting.

  keyWindow = new Window("misc Keys");
  {
    Frame* keyFrame;       //!< The Frame for a new Key-setting.

    keyFrame = new Frame("misc Keys:");
    {
      Box* keysBox;          //!< The Box that holds the Key-settings.
      keysBox = new Box('v');
      {
        Button* closeButton;    //!< The CloseButton for this key-settings.

        keysBox->setGroupName(CONFIG_SECTION_MISC_KEYS);
        keysBox->fill(addKey(CONFIG_NAME_QUIT , "ESCAPE"));
        keysBox->fill(addKey(CONFIG_NAME_PAUSE, "PAUSE"));
        keysBox->fill(addKey(CONFIG_NAME_NEXT_WORLD, "x"));
        keysBox->fill(addKey(CONFIG_NAME_PREV_WORLD, "z"));
        keysBox->fill(addKey(CONFIG_NAME_VIEW0, "1"));
        keysBox->fill(addKey(CONFIG_NAME_VIEW1, "2"));
        keysBox->fill(addKey(CONFIG_NAME_VIEW2, "3"));
        keysBox->fill(addKey(CONFIG_NAME_VIEW3, "4"));
        keysBox->fill(addKey(CONFIG_NAME_VIEW4, "5"));
        keysBox->fill(addKey(CONFIG_NAME_VIEW5, "6"));

        closeButton = new Button("close");
#ifdef HAVE_GTK2
        closeButton->connectSignal("button_press_event", keyWindow, Window::windowClose);
#endif /* HAVE_GTK2 */

        keysBox->fill(closeButton);
      }
      keyFrame->fill(keysBox);
    }
    keyWindow->fill(keyFrame);
  }
  Window::addWindow(keyWindow);
#ifdef HAVE_GTK2
  keyWindow->connectSignal("destroy", keyWindow, Window::windowClose);
  keyWindow->connectSignal("delete_event", keyWindow, Window::windowClose);
#endif /* HAVE_GTK2 */

  this->openButton = new Button("misc");
#ifdef HAVE_GTK2
  this->openButton->connectSignal("button_press_event", keyWindow, Window::windowOpen);
#endif /* HAVE_GTK2 */
}

/**
 * @returns the OpenButton of a Misc
*/
Button* MiscKeys::getOpenButton()
{
  return this->openButton;
}


/**
 *  adds a new Key.
 * @param key the number of the Key
 * @param name The name of the new Key.
 * @returns A widget that has the Key-Box
*/
Widget* addKey(const char* name, const char* defaultVal)
{
  InputKey* inputKey = new InputKey;
  inputKey->keyBox = new Box();
  inputKey->keyButton = new Button(name);
  if (defaultVal)
    inputKey->keyOLabel = new OptionLabel(name, defaultVal);
  else
    inputKey->keyOLabel = new OptionLabel(name, name);
  inputKey->keyOLabel->saveability();

#ifdef HAVE_GTK2
  //inputKey->keyButton->connectSignal("key_press_event", inputKey->keyButton, key_cb);
  inputKey->keyButton->connectSignal("button_press_event", inputKey, inputWindowEvent);
#endif /* HAVE_GTK2 */
  inputKey->keyBox->fill(inputKey->keyButton);
  inputKey->keyBox->fill(inputKey->keyOLabel);
  return inputKey->keyBox;
}


#ifdef HAVE_GTK2
gint inputWindowEvent(GtkWidget* w, GdkEventKey* event, void* inputKey)
{
  GuiKeys::inputButton->setTitle("press a Key");
  GuiKeys::keySignal = GuiKeys::inputButton->connectSignal("key_press_event", inputKey, key_cb);
  GuiKeys::inputWindow->open();
}

/**
 *  Function which gets keystrokes
 * @param w the widget that released the Function.
 * @param event The event that happened.
 * @param Widget the Widget which will be applied.
 * @returns Nothing
*/
gint key_cb(GtkWidget* w, GdkEventKey* event, void* inputKey)
{
  InputKey* inputkey =(InputKey*) inputKey;
  char title [50];

  switch(event->keyval)
    {
    case GDK_Up:
      strcpy(title, "UP");
      break;
    case GDK_Down:
      strcpy(title, "DOWN");
      break;
    case GDK_Left:
      strcpy(title, "LEFT");
      break;
    case GDK_Right:
      strcpy(title, "RIGHT");
      break;

    case GDK_space:
      strcpy(title, "SPACE");
      break;

    case GDK_Return:
      strcpy(title, "RETURN");
      break;

      // Special Keys //
    case GDK_BackSpace:
      strcpy(title, "BACKSPACE");
      break;
    case GDK_Scroll_Lock:
      strcpy(title, "SCROLLOCK");
      break;
    case GDK_minus:
      strcpy(title, "MINUS");
      break;
    case GDK_plus:
      strcpy(title, "PLUS");
      break;
    case GDK_slash:
      strcpy(title, "SLASH");
      break;
    case GDK_period:
      strcpy(title, "PERIOD");
      break;
    case GDK_comma:
      strcpy(title, "COMMA");
      break;
    case GDK_colon:
      strcpy(title, "COLON");
      break;
    case GDK_semicolon:
      strcpy(title, "SEMICOLON");
      break;
    case GDK_less:
      strcpy(title, "LESS");
      break;
    case GDK_equal:
      strcpy(title, "EQUALS");
      break;
    case GDK_greater:
      strcpy(title, "GREATER");
      break;
    case GDK_question:
      strcpy(title, "QUESTION");
      break;
    case GDK_at:
      strcpy(title, "AT");
      break;
    case GDK_bracketleft:
      strcpy(title, "LEFTBRACKET");
      break;
    case GDK_bracketright:
      strcpy(title, "RIGHTBRACKET");
      break;
    case GDK_backslash:
      strcpy(title, "BACKSLASH");
      break;
    case GDK_underscore:
      strcpy(title, "UNDERSCORE");
      break;
    case GDK_quoteleft:
      strcpy(title, "BACKQUOTE");
      break;

    case GDK_Page_Up:
      strcpy(title, "PAGEUP");
      break;
    case GDK_Page_Down:
      strcpy(title, "PAGEDOWN");
      break;
    case GDK_Home:
      strcpy(title, "HOME");
      break;
    case GDK_Insert:
      strcpy(title, "INSERT");
      break;

    case GDK_Escape:
      strcpy(title, "ESCAPE");
      break;
    case GDK_Tab:
      strcpy(title, "TAB");
      break;
    case GDK_Shift_L:
      strcpy(title, "LSHIFT");
      break;
    case GDK_Shift_R:
      strcpy(title, "R_SHIFT");
      break;
    case GDK_Control_L:
      strcpy(title, "LCTRL");
      break;
    case GDK_Control_R:
      strcpy(title, "RCTRL");
      break;
    case GDK_Alt_L:
      strcpy(title, "LALT");
      break;
    case GDK_Alt_R:
      strcpy(title, "RALT");
      break;
      // FXX KEYS //
    case GDK_F1:
      strcpy(title, "F1");
      break;
    case GDK_F2:
      strcpy(title, "F2");
      break;
    case GDK_F3:
      strcpy(title, "F3");
      break;
    case GDK_F4:
      strcpy(title, "F4");
      break;
    case GDK_F5:
      strcpy(title, "F5");
      break;
    case GDK_F6:
      strcpy(title, "F6");
      break;
    case GDK_F7:
      strcpy(title, "F7");
      break;
    case GDK_F8:
      strcpy(title, "F8");
      break;
    case GDK_F9:
      strcpy(title, "F9");
      break;
    case GDK_F10:
      strcpy(title, "F10");
      break;
    case GDK_F11:
      strcpy(title, "F11");
      break;
    case GDK_F12:
      strcpy(title, "F12");
      break;


    default:
      char* tmp;
      sprintf(tmp, "%c", event->keyval);
      printf("other key %s \n", tmp);
      strcpy(title, tmp);
      break;
    }

  inputkey->keyOLabel->setValue(title);
  GuiKeys::inputButton->disconnectSignal(GuiKeys::keySignal);
  GuiKeys::inputWindow->close();
}
#endif /* HAVE_GTK2 */
