/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "shell_buffer.h"
#include "debug.h"
#include "list.h"
#include "shell.h"

#include "stdlibincl.h"

using namespace std;


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
ShellBuffer::ShellBuffer ()
{
  ShellBuffer::singletonRef = this;
  this->shell = NULL;

  this->lineCount = 0;
  this->keepBufferArray[0] = '\0';
  this->keepBuffer = false;
  this->buffer = new tList<char>;
  this->bufferIterator = this->buffer->getIterator();

  this->setBufferSize(100);
}

ShellBuffer* ShellBuffer::singletonRef = NULL;

/**
 * standard deconstructor
*/
ShellBuffer::~ShellBuffer ()
{
  if (this->shell != NULL)
    delete this->shell;

  this->flushBuffers();
  delete bufferIterator;
  delete buffer;

  ShellBuffer::singletonRef = NULL;
}

/**
 * registers the Shell to the Buffer
 * @param shell the Shell to register.
 */
void ShellBuffer::registerShell(Shell* shell)
{
  if (this->shell == NULL)
    this->shell = shell;
  else
    PRINTF(1)("already registered a Shell to the ShellBuffer\n");
}

/**
 * unregisters the Shell from the Buffer
 * @param shell the Shell to unregister.
 */
void ShellBuffer::unregisterShell(Shell* shell)
{
  if (this->shell == shell)
    this->shell = NULL;
  else
    PRINTF(1)("cannot unregister shell, because it is not registered to the ShellBuffer\n");
}

/**
 * deletes all the Buffers
 */
void ShellBuffer::flushBuffers()
{
  // delete all the Chars in the Buffers
  char* charElem = bufferIterator->firstElement();
  while (charElem != NULL)
  {
    delete[] charElem;
    charElem = bufferIterator->nextElement();
  }
  delete this->bufferIterator;
  delete this->buffer;
  this->buffer = new tList<char>;
  this->bufferIterator = this->buffer->getIterator();
}

/**
 * adds a new Line to the List of Buffers
 * @param line the Line as in the first argument in printf
 */
bool ShellBuffer::addBufferLineStatic(const char* line, ...)
{
  va_list arguments;
  va_start(arguments, line);

#if DEBUG < 3
  if (ShellBuffer::singletonRef == NULL)
#endif

    vprintf(line, arguments);
#if DEBUG < 3
  else
#else
  if (ShellBuffer::singletonRef != NULL)
#endif
    ShellBuffer::singletonRef->addBufferLine(line, arguments);
  return true;
}

/**
 * add a Line to the List of Buffers
 * @param line
 * @param arguments
 *
 * This function Adds one line to the buffer.
 * and displays the line as the First Line of the display-buffer
 */
void ShellBuffer::addBufferLine(const char* line, va_list arguments)
{
  vsprintf(this->bufferArray, line, arguments);

  char* inputEnd;
  char* newLineBegin;
  char* newLineEnd;

   // check if we have something left in the buffers
  if (unlikely(this->keepBuffer))
  {
    strcat(this->keepBufferArray, this->bufferArray);
    inputEnd = this->keepBufferArray + strlen(this->keepBufferArray);
    newLineBegin = this->keepBufferArray;
    this->keepBuffer = false;
  }
  else
  {
    inputEnd = this->bufferArray + strlen(this->bufferArray);
    newLineBegin = this->bufferArray;
  }

   // adding all the new Lines
  while (newLineBegin < inputEnd )
  {
    newLineEnd = strchr(newLineBegin, '\n');
    if (newLineEnd != NULL && *newLineEnd == '\n')
      *newLineEnd = '\0';
    else
    {
//       newLineEnd = newLineBegin + strlen(newLineBegin);
      strcpy(this->keepBufferArray, newLineBegin);
      this->keepBuffer = true;
      break;
    }

    char* addLine = new char[strlen(newLineBegin)+1];
    strcpy(addLine, newLineBegin);

    this->lineCount++;
    this->buffer->add(addLine);
    if (likely (this->shell != NULL) && unlikely (this->shell->isActive()))
      this->shell->printToDisplayBuffer(addLine);

    if (this->buffer->getSize() > this->bufferSize)
    {
      delete[] this->buffer->firstElement();
      this->buffer->remove(this->buffer->firstElement());
    }

    newLineBegin = newLineEnd+1;
  }
}

/**
 * moves the buffer around lineCount lines upwards (negative values move down)
 * @param lineCount the Count of lines to move upwards
 *
 * @todo
 */
void ShellBuffer::moveBuffer(unsigned int lineCount)
{
}

/**
 * @param lineNumber the n-th line from the bottom
 * @returns the Buffer at Line lineNumber
 */
const char* ShellBuffer::getBufferLine(unsigned int lineNumber)
{
  tIterator<char>* charIterator = this->buffer->getIterator();
  char* charElem = charIterator->firstElement();

  int i = 1;
  while (charElem != NULL)
  {
    if (i++ < lineNumber)
    {
      delete charIterator;
      return charElem;
    }

    charElem = charIterator->nextElement();
  }
  delete charIterator;
}

/**
 * displays some nice output from the Shell
 */
void ShellBuffer::debug() const
{
  PRINT(3)("Debugging output to console (not this shell)\n");

  char* tmpChar = bufferIterator->firstElement();
  while(tmpChar != NULL)
  {
    printf(tmpChar);
    tmpChar = bufferIterator->nextElement();
  }
}
