/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "helper_functions.h"
#include "stdlibincl.h"

using namespace std;

/**
 * checks if the input was a Bool
 * @param BOOL a String that holds a bool: must be one of those: 1,0,true,false,TRUE,FALSE
 * @param defaultValue a default value that is set, if BOOL is corrupt
 * @return returns the bool, if BOOL was correct otherwise defaultValue
 */
bool isBool(const char* BOOL, bool defaultValue)
{
  if(!strcmp(BOOL, "1") || !strcmp( BOOL,"true") || !strcmp(BOOL,"TRUE"))
    return true;
  else if (!strcmp(BOOL, "0") || !strcmp( BOOL,"false") || !strcmp(BOOL,"FALSE"))
    return false;
  else
    return defaultValue;

}

int isInt(const char* INT, int defaultValue)
{
  char* endPtr = NULL;
  int result = strtol(INT, &endPtr, 10);

  if ( endPtr >= INT && endPtr < INT + strnlen(INT, 10))
    return defaultValue;
  else
    return result;
}

float isFloat(const char* FLOAT, float defaultValue)
{
  char* endPtr = NULL;
  double result = strtod(FLOAT, &endPtr);

  if ( endPtr >= FLOAT && endPtr < FLOAT + strlen(FLOAT))
    return defaultValue;
  else
    return result;
}


const char* isString(const char* STRING, const char* defaultValue)
{
  if (STRING != NULL && strlen(STRING) > 0)
    return STRING;
  else
    return defaultValue;
}
