/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "shell_completion.h"

#include "shell_input.h"
#include "shell_command.h"

#include "substring.h"
#include "base_object.h"
#include "class_list.h"
#include "list.h"
#include "debug.h"

#include "stdlibincl.h"

using namespace std;

/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
ShellCompletion::ShellCompletion(ShellInput* input)
{
  this->completionList = NULL;
  this->input = input;
}


/**
 * standard deconstructor
*/
ShellCompletion::~ShellCompletion ()
{
  // delete what has to be deleted here
  if (this->completionList)
  {
    this->emptyCompletionList();
    delete this->completionList;
  }
}



/**
 * autocompletes the Shell's inputLine
 * @returns true, if a result was found, false otherwise
 *
 * @todo implement it!!
 */
bool ShellCompletion::autoComplete(ShellInput* input)
{
  const char* completionLine;      //< the inputLine we complete.

  long classID;                    //< the classID retrieved from the Class.
  tList<BaseObject>* objectList;   //< the list of Objects stored in classID
  bool emptyComplete = false;      //< if the completion input is empty string. e.g ""
  long completeType = SHELLC_NONE; //< the Type we'd like to complete.
  const char* completeString;      //< the string to complete.


  PRINTF(5)("AutoComplete on input\n");
  this->emptyCompletionList();

  if (input != NULL)
    this->input = input;
  if (this->input == NULL)
  {
    PRINTF(2)("No ShellInput supplied\n");
    return false;
  }

  // Check if we are in a input. eg. the supplied string "class " and now we complete either function or object
  if (this->input->getInput() != NULL &&
      strrchr(this->input->getInput(), ' ') >= this->input->getInput() + strlen(this->input->getInput())-1)
  {
    emptyComplete = true;
  }

  // CREATE INPUTS
  if (this->input->getInput() == NULL)
    completionLine = "";
  else
    completionLine = this->input->getInput() + strspn(this->input->getInput(), " \t\n");
  SubString inputSplits(completionLine, true);

  // What String will be completed
  if (emptyComplete == true)
    completeString = "";
  else
    completeString = inputSplits.getString(inputSplits.getCount()-1);

  // CLASS COMPLETION
  if (inputSplits.getCount() == 0)
  {
    PRINTF(5)("Listing all Classes\n");
    completeType |= SHELLC_CLASS;
  }
  else if (inputSplits.getCount() == 1 && emptyComplete == false)
  {
    printf("trying to complete a Class with '%s'\n", inputSplits.getString(0));
    completeType |= SHELLC_CLASS;
  }

  // OBJECT/FUNCTION COMPLETIONS
  else if ((inputSplits.getCount() == 1 && emptyComplete == true) ||
            (inputSplits.getCount() == 2 && emptyComplete == false))
  {
    classID = ClassList::StringToID(inputSplits.getString(0));
    objectList = ClassList::getList(classID);
    if (classID == CL_NULL)
      return false;
    else
    {
      if (objectList != NULL && objectList->getSize() == 1)
        completeType |= SHELLC_FUNCTION;
      completeType |= SHELLC_OBJECT;
    }
  }
  else if ((inputSplits.getCount() == 2 && emptyComplete == true) ||
            (inputSplits.getCount() == 3 && emptyComplete == false))
  {
    classID = ClassList::StringToID(inputSplits.getString(0));
    if (classID == CL_NULL)
      return false;
    else
     completeType |= SHELLC_FUNCTION;
  }

  if (completeType & SHELLC_CLASS)
    this->objectComplete(completeString, CL_SHELL_COMMAND_CLASS);
  if (completeType & SHELLC_OBJECT)
    this->objectComplete(completeString, classID);
  if (completeType & SHELLC_FUNCTION)
    this->functionComplete(completeString, classID);


  this->generalComplete(completeString);
  return true;
}

/**
 * autocompletes a className
 * @param classBegin the Beginning of a String to autoComplete
 * @return true on success, false otherwise
 */
bool ShellCompletion::classComplete(const char* classBegin)
{
  if (unlikely(classBegin == NULL))
    return false;
  const tList<const char>* clList = ClassList::getClassList();
  if (clList != NULL)
  {
    if (!this->addToCompleteList(clList, classBegin))
      return false;
  }
  else
    return false;
  return true;
}

/**
 * autocompletes an ObjectName
 * @param objectBegin the beginning string of a Object
 * @param classID the ID of the Class to search for.
 * @return true on success, false otherwise
 */
bool ShellCompletion::objectComplete(const char* objectBegin, long classID)
{
  if (unlikely(objectBegin == NULL))
    return false;
  const tList<BaseObject>* boList = ClassList::getList(classID);
  if (boList != NULL)
  {
    //printf("%s\n", boList->firstElement()->getName());
    if (!this->addToCompleteList(boList, objectBegin))
      return false;
  }
  else
    return false;
  return true;
}

/**
 * completes a Function
 * @param functionBegin the beginning of the function String
 */
bool ShellCompletion::functionComplete(const char* functionBegin, long classID)
{
  if (unlikely(functionBegin == NULL))
    return false;
  tList<const char> fktList;
  ShellCommandClass::getCommandListOfClass(ClassList::IDToString(classID), &fktList);
  //printf("%s\n", boList->firstElement()->getName());
  if (!this->addToCompleteList(&fktList, functionBegin))
    return false;
  return true;
}

/**
 * completes the inputline on grounds of an inputList
 * @param begin the String to search in the inputList, and to extend with it.
 * @param displayAs how to display the found value to the user, printf-style, !!with only one %s!! ex.: "::%s::"
 * @param addBack what should be added at the end of the completion
 * @param addFront what should be added to the front of one finished completion
 * @return true if ok, false otherwise
 */
bool ShellCompletion::generalComplete(const char* begin, const char* displayAs, const char* addBack, const char* addFront)
{
  if (completionList == NULL || this->input == NULL )
    return false;
  if (completionList->getSize() == 0)
    return false;

  ShellC_Element* addElem = completionList->firstElement();
  const char* addString = addElem->name;
  unsigned int addLength = 0;
  unsigned int inputLenght = strlen(begin);

  // Determin the longest Match
  if (addString != NULL)
    addLength = strlen(addString);
  tIterator<ShellC_Element>* charIterator = completionList->getIterator();
  ShellC_Element* charElem = charIterator->firstElement();
  while (charElem != NULL)
  {
    PRINTF(0)(displayAs, charElem->name);
    for (unsigned int i = inputLenght; i < addLength; i++)
      if (addString[i] != charElem->name[i])
      {
       addLength = i;
       break;
      }
    charElem = charIterator->nextElement();
  }
  delete charIterator;

  if (addLength >= inputLenght)
  {
    char* adder = new char[addLength+1];
    strncpy(adder, addString, addLength);
    adder[addLength] = '\0';

    if (this->input)
    {
     this->input->removeCharacters(inputLenght);
     this->input->addCharacters(adder);

      if (completionList->getSize() == 1)
      {
        if ( addBack != NULL )
         this->input->addCharacters(addBack);
        this->input->addCharacter(' ');
      }
     delete[] adder;
    }
  }
  return true;
}

/**
 * searches for classes, which beginn with completionBegin
 * @param inputList the List to parse through
 * @param completionBegin the beginning string
 * !! The strings MUST NOT be deleted !!
 */
bool ShellCompletion::addToCompleteList(const tList<const char>* inputList, const char* completionBegin)
{
  if (inputList == NULL || completionBegin == NULL)
    return false;
  unsigned int searchLength = strlen(completionBegin);

  tIterator<const char>* iterator = inputList->getIterator();
  const char* enumString = iterator->firstElement();
  while (enumString != NULL)
  {
    if (strlen(enumString) >= searchLength &&
        !strncasecmp(enumString, completionBegin, searchLength))
    {
      printf("%s\n", enumString);
      ShellC_Element* newElem = new ShellC_Element;
      newElem->name = enumString;
      this->completionList->add(newElem);
    }
    enumString = iterator->nextElement();
  }
  delete iterator;

  return true;
}

/**
 * searches for classes, which beginn with completionBegin
 * @param inputList the List to parse through
 * @param completionBegin the beginning string
 * !! The strings MUST NOT be deleted !!
 */
bool ShellCompletion::addToCompleteList(const tList<BaseObject>* inputList, const char* completionBegin)
{
  if (inputList == NULL || completionBegin == NULL)
    return false;
  unsigned int searchLength = strlen(completionBegin);

  tIterator<BaseObject>* iterator = inputList->getIterator();
  BaseObject* enumBO = iterator->firstElement();
  while (enumBO != NULL)
  {
    if (enumBO->getName() != NULL &&
        strlen(enumBO->getName()) >= searchLength &&
        !strncasecmp(enumBO->getName(), completionBegin, searchLength))
    {
      ShellC_Element* newElem = new ShellC_Element;
      newElem->name = enumBO->getName();
      this->completionList->add(newElem);
      printf("%s\n",enumBO->getName());
    }
    enumBO = iterator->nextElement();
  }
  delete iterator;

  return true;
}


void ShellCompletion::emptyCompletionList()
{
  if (this->completionList != NULL)
  {
    tIterator<ShellC_Element>* elemIT = this->completionList->getIterator();
    ShellC_Element* elem = elemIT->firstElement();
    while (elem != NULL)
    {
      delete elem;
      elem = elemIT->nextElement();
    }
    delete this->completionList;
  }
  this->completionList = new tList<ShellC_Element>;
}
