/*!
 * @file shell_completion.h
 * @brief The Shell Completion Tasks
*/

#ifndef _SHELL_COMPLETION_H
#define _SHELL_COMPLETION_H

// FORWARD DECLARATION
class BaseObject;
class ShellInput;
template<class T> class tList;
#ifndef NULL
#define NULL 0            //!< a pointer to NULL
#endif

typedef enum {
  SHELLC_CLASS,
  SHELLC_OBJECT,
  SHELLC_FUNCTION,
  SHELLC_ALIAS,
} SHELL_CTYPE;

struct ShellC_Element{
  const char*     name;     //!<
  SHELL_CTYPE     type;
};

//! A class for ...
class ShellCompletion {

 public:
  ShellCompletion(ShellInput* input = NULL);
  virtual ~ShellCompletion();

  bool autoComplete(ShellInput* input = NULL);
  bool classComplete(const char* classBegin);
  long classMatch(const char* input, unsigned int* length);
  bool objectComplete(const char* objectBegin, long classID);
  bool objectMatch(const char* objectBegin, long classID, unsigned int* length);
  bool functionComplete(const char* functionBegin);
  bool functionMatch(const char* functionBegin, long classID, unsigned int* length);

  bool generalComplete(const tList<ShellC_Element>* stringList, const char* begin, const char* displayAs = "%s", const char* addBack = NULL, const char* addFront = NULL);

  const tList<ShellC_Element>* addToCompleteList(const tList<const char>* inputList, const char* completionBegin);
  const tList<ShellC_Element>* addToCompleteList(const tList<BaseObject>* inputList, const char* completionBegin);
  void emptyCompletionList();
//    const tList<const char>* createCompleteList(const tList<ShellCommandBase>* inputList, const char* completionBegin);


 private:
   tList<ShellC_Element>*   completionList;          //!< A list of completions, that are io.
   ShellInput*              input;
};

#endif /* _SHELL_COMPLETION_H */
