/*!
 * @file shell_completion.h
 * @brief The Shell Completion Tasks
*/

#ifndef _SHELL_COMPLETION_H
#define _SHELL_COMPLETION_H

// FORWARD DECLARATION
class BaseObject;
class ShellInput;
template<class T> class tList;
#ifndef NULL
#define NULL 0            //!< a pointer to NULL
#endif

//! A class for ...
class ShellCompletion {

 public:
  ShellCompletion(ShellInput* input = NULL);
  virtual ~ShellCompletion();

  bool autoComplete(ShellInput* input);
  bool classComplete(const char* classBegin);
  long classMatch(const char* input, unsigned int* length);
  bool objectComplete(const char* objectBegin, long classID);
  bool objectMatch(const char* objectBegin, long classID, unsigned int* length);
  bool functionComplete(const char* functionBegin);
  bool functionMatch(const char* functionBegin, long classID, unsigned int* length);

  bool generalComplete(const tList<const char>* stringList, const char* begin, const char* displayAs = "%s", const char* addBack = NULL, const char* addFront = NULL);

  const tList<const char>* createCompleteList(const tList<const char>* inputList, const char* classNameBegin);
  const tList<const char>* createCompleteList(const tList<BaseObject>* inputList, const char* classNameBegin);
//    const tList<const char>* createCompleteList(const tList<ShellCommandBase>* inputList, const char* classNameBegin);


 private:
   tList<const char>*       completionList;          //!< A list of completions, that are io.
   ShellInput*              input;
};

#endif /* _SHELL_COMPLETION_H */
