/*!
 * @file shell_input.h
 * @brief Definition of ...
*/

#ifndef _SHELL_INPUT_H
#define _SHELL_INPUT_H

#include "text_engine.h"
#include "event_listener.h"

// FORWARD DECLARATION
template<class T> class tList;
class ShellCompletion;


//! A class for ...
class ShellInput : public Text,  public EventListener {

 public:
  ShellInput();
  virtual ~ShellInput();


  // InputLine
  void flush();
  void addCharacter(char character);
  void addCharacters(const char* characters);
  void removeCharacters(unsigned int characterCount = 1);
  void setRepeatDelay(float repeatDelay, float repeatRate);
  bool executeCommand();
  void help() const;
  const char* getInputString() const { return this->inputLine; };


  virtual void tick(float dt);
  virtual void process(const Event &event);

 private:
    // HANDLING TEXT INPUT
   ShellCompletion*         completion;             //!< The Completion Interface.

   char*                    inputLine;              //!< the Char-Array of the Buffer @todo not needed anymore
   float                    repeatRate;             //!< The Repeat-Delay.
   float                    repeatDelay;            //!< The delay of the first Character of a given Character.
   float                    delayed;                //!< how much of the delay is remaining.
   int                      pressedKey;             //!< the pressed key that will be repeated.

   tList<char>*             inputHistory;           //!< The history of given commands.

};

#endif /* _SHELL_INPUT_H */
