/*!
 * @file shell.h
 * Definition of a on-screen-shell
*/

#ifndef _SHELL_H
#define _SHELL_H

#include "element_2d.h"
#include "event_listener.h"

#include <stdarg.h>

// FORWARD DECLARATION
class Text;
class ShellInput;
class ShellCommandBase;
template<class T> class tList;
template<class T> class tIterator;

//! A class that is able to redirect all output to a openGL-Shell, and that one can use to input some commands
/**
 * the major idea is, that all the Output can be redirected to the Shell,
 * and does not have to be displayed to the opening Shell, this is good,
 * for developers using Windows, where all output is otherwise redirected
 * to stdout.txt
 *
 * Furthermore the Shell should enable us, to input some simple commands
 * Each Class can tell check itself in to the Shell, and listen for commands.
 *
 * @todo implement what is written above :/
 */
class Shell : public Element2D, public EventListener {

  public:
    virtual ~Shell();
    /** @returns a Pointer to the only object of this Class */
    inline static Shell* getInstance() { if (!Shell::singletonRef) Shell::singletonRef = new Shell();  return Shell::singletonRef; };
    /** @returns true if this class is instanciated, false otherwise */
    inline static bool isInstanciated() { return (Shell::singletonRef == NULL)?false:true; };

    void activate();
    void deactivate();
    inline bool isActive() const { return this->bActive; };

    void setTextSize(unsigned int textSize, unsigned int lineSpacing = 1);
    void rebuildText();

    // BUFFERS
    void flush();
    void setBufferDisplaySize(unsigned int bufferDisplaySize);
    void printToDisplayBuffer(const char* text);

    void clear();

    // EventListener
    virtual void process(const Event &event);

    // Element2D-functions
    virtual void draw() const;

    void debug() const;

  private:

    // helpers //
    Vector calculateLinePosition(unsigned int lineNumber);
//     void testI (int i);
//     void testS (const char* s);
//     void testB (bool b);
//     void testF (float f);
//     void testSF (const char* s, float f);

  private:
    Shell();
    static Shell*            singletonRef;           //!< The singleton-reference to the only memeber of this class.

    // GENERAL
    bool                     bActive;                //!< if the shell is active;
    unsigned int             shellHeight;            //!< The hight of the Shell in Pixels
    unsigned int             lineSpacing;            //!< The Spacing between lines.
    unsigned int             textSize;               //!< The size of the text.

    // HANDLING TEXT INPUT
    ShellInput*              shellInput;
    // BUFFER
    unsigned int             bufferDisplaySize;      //!< The Size of the Display-buffer, in lines (not in characters)
    Text**                   bufferText;             //!< A list of stored bufferTexts for the display of the buffer
};

#endif /* _SHELL_H */
