/*!
 * @file shell_input.h
 * @brief Definition of ...
*/

#ifndef _SHELL_INPUT_H
#define _SHELL_INPUT_H

// FORWARD DECLARATION
class Text;
template<class T> class tList;


//! A class for ...
class ShellInput {

 public:
  ShellInput();
  virtual ~ShellInput();


  // InputLine
  void flush();
  void addCharacter(char character);
  void addCharacters(const char* characters);
  void removeCharacters(unsigned int characterCount = 1);
  void setRepeatDelay(float repeatDelay, float repeatRate);


 private:
    // HANDLING TEXT INPUT
   Text*                    inputLineText;          //!< The inputLine of the Shell
   char*                    inputLine;              //!< the Char-Array of the Buffer
   float                    repeatRate;             //!< The Repeat-Delay.
   float                    repeatDelay;            //!< The delay of the first Character of a given Character.
   float                    delayed;                //!< how much of the delay is remaining.
   int                      pressedKey;             //!< the pressed key that will be repeated.

   tList<char>*             inputHistory;           //!< The history of given commands.

};

#endif /* _SHELL_INPUT_H */
