/*!
 * @file shell_completion.h
 * @brief The Shell Completion Tasks
*/

#ifndef _SHELL_COMPLETION_H
#define _SHELL_COMPLETION_H

// FORWARD DECLARATION
class BaseObject;
template<class T> class tList;
#ifndef NULL
#define NULL 0            //!< a pointer to NULL
#endif

//! A class for ...
class ShellCompletion {

 public:
  ShellCompletion();
  virtual ~ShellCompletion();

  bool autoComplete(const char* inputLine);
  bool classComplete(const char* classBegin);
  bool objectComplete(const char* objectBegin, long classID);
  bool functionComplete(const char* functionBegin);

  bool generalComplete(const tList<const char>* stringList, const char* begin, const char* displayAs = "%s", const char* addBack = NULL, const char* addFront = NULL);

  const tList<const char>* createCompleteList(const tList<const char>* inputList, const char* classNameBegin);
  const tList<const char>* createCompleteList(const tList<BaseObject>* inputList, const char* classNameBegin);
//    const tList<const char>* createCompleteList(const tList<ShellCommandBase>* inputList, const char* classNameBegin);


 private:
   tList<const char>*       completionList;          //!< A list of completions, that are io.
};

#endif /* _SHELL_COMPLETION_H */
