/*!
 * @file shell_buffer.h
 * @brief The Shell buffer Tasks
*/

#ifndef _SHELL_BUFFER_H
#define _SHELL_BUFFER_H

#include <stdarg.h>

#define      SHELL_BUFFER_SIZE       16384         //!< The Size of the input-buffers (should be large enough to carry any kind of input)

// FORWARD DECLARATION
template<class T> class tList;
template<class T> class tIterator;
class Text;

//! A class for ...
class ShellBuffer {

 public:
  ShellBuffer();
  virtual ~ShellBuffer();


  // BUFFER //
  /** @param bufferSize the new Buffer-Size */
  void setBufferSize(unsigned int bufferSize) { this->bufferSize = bufferSize; };
  void setBufferDisplaySize(unsigned int bufferDisplaySize);
  void flushBuffers();
  static bool addBufferLineStatic(const char* line, ...);
  void addBufferLine(const char* line, va_list arg);
  void printToDisplayBuffer(const char* text);
  void moveBuffer(unsigned int lineCount);
//    void moveBufferTo(unsigned int lineNumber);
  const char* getBufferLine(unsigned int lineNumber);


 private:
   unsigned int             bufferSize;             //!< The Size of the buffer
   unsigned int             bufferDisplaySize;      //!< The Size of the Display-buffer, in lines (not in characters)
   tList<char>*             buffer;                 //!< A list of stored char-arrays(strings) to store the history
   tIterator<char>*         bufferIterator;         //!< An iterator for the Shells main buffer.

   Text**                   bufferText;             //!< A list of stored bufferTexts for the display of the buffer
   char                     bufferArray[SHELL_BUFFER_SIZE];     //!< a BUFFER for fast writing
   char                     keepBufferArray[SHELL_BUFFER_SIZE]; //!< a BUFFER to have multi-non-newLine commands be copied into the shell.
   bool                     keepBuffer;             //!< if the keepbuffer contains unfinished lines.

};

#endif /* _SHELL_BUFFER_H */
