/*!
 * @file shell_command.h
 * Definition of a on-screen-shell
*/

#ifndef _SHELL_COMMAND_H
#define _SHELL_COMMAND_H

#include "base_object.h"

#include "helper_functions.h"
#include "substring.h"
#include "functor_list.h"

#include <stdarg.h>

#define SHELL_COMMAND_MAX_SIZE



// FORWARD DECLARATION
template<class T> class tList;


///////////////////////
// MACRO DEFINITIONS //
///////////////////////
#define   l_BOOL_DEFGRAB(i)         this->defaultBools[i]
#define   l_INT_DEFGRAB(i)          this->defaultInts[i]
#define   l_UINT_DEFGRAB(i)         (unsigned int)this->defaultInts[i]
#define   l_LONG_DEFGRAB(i)         (long)this->defaultInts[i]
#define   l_FLOAT_DEFGRAB(i)        this->defaultFloats[i]
#define   l_STRING_DEFGRAB(i)       this->defaultStrings[i]

//////////////////////////
// COMMAND REGISTRATION //
//////////////////////////
// NO ARGUMENTS
#define ShellCommandRegister0() \
  static void registerCommand(const char* commandName, ClassID classID, void (T::*function)()) \
  { \
    if (isRegistered(commandName, classID, 0)== true) \
      return; \
    new ShellCommand<T>(commandName, classID, function); \
  }

#define ShellCommandRegister1(t1) \
  static void registerCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE), t1##_TYPE d1 = t1##_DEFAULT) \
  { \
    if (isRegistered(commandName, classID, 1, t1##_PARAM)== true) \
      return; \
    new ShellCommand<T>(commandName, classID, function, d1); \
  }

#define ShellCommandRegister2(t1,t2) \
  static void registerCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE, t2##_TYPE), t1##_TYPE d1 = t1##_DEFAULT, t2##_TYPE d2 = t2##_DEFAULT) \
  { \
    if (isRegistered(commandName, classID, 2, t1##_PARAM, t2##_PARAM)== true) \
      return; \
    new ShellCommand<T>(commandName, classID, function, d1, d2); \
  }

#define ShellCommandRegister3(t1,t2,t3) \
  static void registerCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE, t2##_TYPE, t3##_TYPE), t1##_TYPE d1 = t1##_DEFAULT, t2##_TYPE d2 = t2##_DEFAULT, t3##_TYPE d3 = t3##_DEFAULT) \
  { \
    if (isRegistered(commandName, classID, 3, t1##_PARAM, t2##_PARAM, t3##_PARAM)== true) \
      return; \
    new ShellCommand<T>(commandName, classID, function, d1, d2, d3); \
  }

#define ShellCommandRegister4(t1,t2,t3,t4) \
  static void registerCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE, t2##_TYPE, t3##_TYPE, t4##_TYPE), t1##_TYPE d1 = t1##_DEFAULT, t2##_TYPE d2 = t2##_DEFAULT, t3##_TYPE d3 = t3##_DEFAULT, t4##_TYPE d4 = t4##_DEFAULT) \
  { \
    if (isRegistered(commandName, classID, 4, t1##_PARAM, t2##_PARAM, t3##_PARAM, t4##_PARAM)== true) \
      return; \
    new ShellCommand<T>(commandName, classID, function, d1, d2, d3, d4); \
  }
#define ShellCommandRegister5(t1,t2,t3,t4,t5) \
  static void registerCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE, t2##_TYPE, t3##_TYPE, t4##_TYPE, t5##_TYPE), t1##_TYPE d1 = t1##_DEFAULT, t2##_TYPE d2 = t2##_DEFAULT, t3##_TYPE d3 = t3##_DEFAULT, t4##_TYPE d4 = t4##_DEFAULT, t5##_TYPE d5 = t5##_DEFAULT) \
  { \
    if (isRegistered(commandName, classID, 5, t1##_PARAM, t2##_PARAM, t3##_PARAM, t4##_PARAM, t5##_PARAM)== true) \
      return; \
    new ShellCommand<T>(commandName, classID, function, d1, d2, d3, d4, d5); \
  }

//////////////////
// CONSTRUCTORS //
/////////////////
#define ShellCommandConstructor0() \
  void (T::*functionPointer_0)(); \
  ShellCommand(const char* commandName, ClassID classID, void (T::*function)()) \
  : ShellCommandBase(commandName, classID, 0) \
  { \
    this->functionPointer_0 = function; \
  }

#define ShellCommandConstructor1(t1) \
  void (T::*functionPointer_1_##t1)(t1##_TYPE); \
  ShellCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE), t1##_TYPE d1) \
  : ShellCommandBase(commandName, classID, 1, t1##_PARAM, d1) \
  { \
    this->functionPointer_1_##t1 = function; \
  }

#define ShellCommandConstructor2(t1,t2) \
  void (T::*functionPointer_2_##t1##_##t2)(t1##_TYPE, t2##_TYPE); \
  ShellCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE, t2##_TYPE), t1##_TYPE d1, t2##_TYPE d2) \
  : ShellCommandBase(commandName, classID, 2, t1##_PARAM, d1, t2##_PARAM, d2) \
  { \
    this->functionPointer_2_##t1##_##t2 = function; \
  }

#define ShellCommandConstructor3(t1,t2,t3) \
  void (T::*functionPointer_3_##t1##_##t2##_##t3)(t1##_TYPE, t2##_TYPE, t3##_TYPE); \
  ShellCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE, t2##_TYPE, t3##_TYPE), t1##_TYPE d1, t2##_TYPE d2, t3##_TYPE d3) \
  : ShellCommandBase(commandName, classID, 3, t1##_PARAM, d1, t2##_PARAM, d2, t3##_PARAM, d3) \
  { \
    this->functionPointer_3_##t1##_##t2##_##t3 = function; \
  }

#define ShellCommandConstructor4(t1,t2,t3,t4) \
  void (T::*functionPointer_4_##t1##_##t2##_##t3##_##t4)(t1##_TYPE, t2##_TYPE, t3##_TYPE, t4##_TYPE); \
  ShellCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE, t2##_TYPE, t3##_TYPE, t4##_TYPE), t1##_TYPE d1, t2##_TYPE d2, t3##_TYPE d3, t4##_TYPE d4) \
  : ShellCommandBase(commandName, classID, 4, t1##_PARAM, d1, t2##_PARAM, d2, t3##_PARAM, d3, t4##_PARAM, d4) \
  { \
    this->functionPointer_4_##t1##_##t2##_##t3##_##t4 = function; \
  }

#define ShellCommandConstructor5(t1,t2,t3,t4,t5) \
  void (T::*functionPointer_5_##t1##_##t2##_##t3##_##t4##_##t5)(t1##_TYPE, t2##_TYPE, t3##_TYPE, t4##_TYPE, t5##_TYPE); \
  ShellCommand(const char* commandName, ClassID classID, void (T::*function)(t1##_TYPE, t2##_TYPE, t3##_TYPE, t4##_TYPE, t5##_TYPE), t1##_TYPE d1, t2##_TYPE d2, t3##_TYPE d3, t4##_TYPE d4, t5##_TYPE d5) \
  : ShellCommandBase(commandName, classID, 5, t1##_PARAM, d1, t2##_PARAM, d2, t3##_PARAM, d3, t4##_PARAM, d4, t5##_PARAM, d5) \
  { \
    this->functionPointer_5_##t1##_##t2##_##t3##_##t4##_##t5 = function; \
  }

///////////////
// EXECUTION //
///////////////
#define ShellCommandExecute0() \
  if (this->paramCount == 0) \
    (dynamic_cast<T*>(object)->*functionPointer_0)()

#define ShellCommandExecute1(t1) \
   else if (this->paramCount == 1 && this->parameters[0] == t1##_PARAM) \
    (dynamic_cast<T*>(object)->*functionPointer_1_##t1)(t1##_FUNC(parameters, t1##_DEFGRAB(0)))

#define ShellCommandExecute2(t1,t2) \
   else if (this->paramCount == 2 && this->parameters[0] == t1##_PARAM && this->parameters[1] == t2##_PARAM) \
    (dynamic_cast<T*>(object)->*functionPointer_2_##t1##_##t2)(t1##_FUNC(sub.getString(0), t1##_DEFGRAB(0)), t2##_FUNC(sub.getString(1), t2##_DEFGRAB(1)))

#define ShellCommandExecute3(t1,t2,t3) \
   else if (this->paramCount == 3 && this->parameters[0] == t1##_PARAM && this->parameters[1] == t2##_PARAM && this->parameters[2] == t3##_PARAM) \
    (dynamic_cast<T*>(object)->*functionPointer_3_##t1##_##t2##_##t3)(t1##_FUNC(sub.getString(0), t1##_DEFGRAB(0)), t2##_FUNC(sub.getString(1), t2##_DEFGRAB(1)), t3##_FUNC(sub.getString(2), t3##_DEFGRAB(2)))

#define ShellCommandExecute4(t1,t2,t3,t4) \
   else if (this->paramCount == 4 && this->parameters[0] == t1##_PARAM && this->parameters[1] == t2##_PARAM && this->parameters[2] == t3##_PARAM && this->parameters[3] == t4##_PARAM) \
    (dynamic_cast<T*>(object)->*functionPointer_4_##t1##_##t2##_##t3##_##t4)(t1##_FUNC(sub.getString(0), t1##_DEFGRAB(0)), t2##_FUNC(sub.getString(1), t2##_DEFGRAB(1)), t3##_FUNC(sub.getString(2), t3##_DEFGRAB(2)), t4##_FUNC(sub.getString(3), t4##_DEFGRAB(3)))

#define ShellCommandExecute5(t1,t2,t3,t4,t5) \
   else if (this->paramCount == 5 && this->parameters[0] == t1##_PARAM && this->parameters[1] == t2##_PARAM && this->parameters[2] == t3##_PARAM && this->parameters[3] == t4##_PARAM && this->parameters[4] == t5##_PARAM) \
    (dynamic_cast<T*>(object)->*functionPointer_5_##t1##_##t2##_##t3##_##t4##_##t5)(t1##_FUNC(sub.getString(0), t1##_DEFGRAB(0)), t2##_FUNC(sub.getString(1), t2##_DEFGRAB(1)), t3##_FUNC(sub.getString(2), t3##_DEFGRAB(2)), t4##_FUNC(sub.getString(3), t4##_DEFGRAB(3)), t5##_FUNC(sub.getString(4), t5##_DEFGRAB(4)))



////////////////
// BASE CLASS //
////////////////
//! a baseClass for all possible ShellCommands
class ShellCommandBase : public BaseObject
{
  public:
    static bool execute (const char* executionString);

    static const tList<ShellCommandBase>* getCommandList() { return ShellCommandBase::commandList; };


  protected:
    ShellCommandBase(const char* commandName, ClassID classID, unsigned int paramCount, ...);
    ~ShellCommandBase();

    static bool isRegistered(const char* commandName, ClassID classID, unsigned int paramCount, ...);
    static const char* paramToString(long parameter);

    void debug();
  private:
    virtual void executeCommand (BaseObject* object, const char* parameters) = NULL;

  protected:
    void*                            functionPointer;     //!< The pointeer to the function of the Class (or static pointer if ClassID == CL_NULL )
    unsigned int                     paramCount;          //!< the count of parameters
    unsigned int*                    parameters;          //!< Parameters
    bool                             isSingleton;         //!< if the Class is Singleton @todo autocheck
    char*                            defaultStrings[FUNCTOR_MAX_ARGUMENTS];
    int                              defaultInts[FUNCTOR_MAX_ARGUMENTS];
    float                            defaultFloats[FUNCTOR_MAX_ARGUMENTS];
    bool                             defaultBools[FUNCTOR_MAX_ARGUMENTS];

  private:
    long                             classID;             //!< The ID of the Class associated to this Command
    const char*                      className;           //!< The Name of the Class associated to this Command

    // STATIC MEMBERS
    static tList<ShellCommandBase>*  commandList;         //!< A list of availiable commands.
};

//! keeps information about a ShellCommand
template<class T> class ShellCommand : public ShellCommandBase
{
  public:
    static void unregisterCommand(const char* commandNaame, ClassID classID);

#ifdef FUNCTOR_LIST
#undef FUNCTOR_LIST
#endif

#define FUNCTOR_LIST(x) ShellCommandRegister ## x
#include "functor_list.h"
#undef FUNCTOR_LIST


  private:
#define FUNCTOR_LIST(x) ShellCommandConstructor ## x
#include "functor_list.h"
#undef FUNCTOR_LIST

    virtual void executeCommand (BaseObject* object, const char* parameters)
    {
//      if (parameters != NULL)
      SubString sub(parameters);
#define FUNCTOR_LIST(x) ShellCommandExecute ## x
#include "functor_list.h"
#undef FUNCTOR_LIST
    }
};

#endif /* _SHELL_COMMAND_H */
