/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: Benjamin Grauer
*/


#include "factory.h"

#include "shell_command.h"
#include "game_loader.h"
using namespace std;

/*  --------------------------------------------------
 *               Factory
 *   --------------------------------------------------
 */

/**
 *  constructor

   set everything to zero and define factoryName
*/
Factory::Factory (const char* factoryName)
{
  this->setClassID(CL_FACTORY, "Factory");
  this->setName(factoryName);

  this->next = NULL;

  Factory::registerFactory(this);
}

/** a reference to the First Factory */
Factory* Factory::first = NULL;

/**
 *  destructor

   clear the Q
*/
Factory::~Factory ()
{
  //  printf("%s\n", this->factoryName);
  //  Factory* tmpDel = this->next;
  //  this->next = NULL;
  if (this->next)
    delete this->next;
}

/**
 *  add a Factory to the Factory Queue
 * @param factory a Factory to be registered
*/
void Factory::registerFactory( Factory* factory)
{
  assert( factory != NULL);

  PRINTF(4)("Registered factory for '%s'\n", factory->getName());

  if( Factory::first == NULL)
  {
    Factory::first = factory;
    ShellCommand<Factory>::registerCommand("create", CL_FACTORY, &Factory::fabricate);
  }
  else
  {
    Factory* tmpFac = Factory::first;
    while( tmpFac->next != NULL)
    {
      tmpFac = tmpFac->next;
    }
    tmpFac->setNext(factory);
  }
}

void Factory::fabricate(const char* className, const char* entityName)
{
  if (className == NULL)
    return;
  Factory* fac = Factory::first;

  while (fac != NULL)
  {
    if (!strcmp(className, fac->getName()))
    {
      PRINTF(3)("Create a new Object of type %s\n", fac->getName());
      BaseObject* object = fac->fabricateDirect();
      if (object != NULL)
      {
        object->setName(entityName);
      }
      break;
    }
    fac = fac->next;
  }
}
