/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: Benjamin Grauer

   2005-06-10: some naming conventions
*/


/**
 *  breaks a string into parts that were initially seperated by comma
 * @param string the string to break into substrings
*/

#include "substring.h"

#include "debug.h"
#include <string.h>
#include <assert.h>

SubString::SubString( const char* string, char splitter)
{
  this->splittersCount = 0;
  if (string == NULL)
  {
    this->strings = NULL;
    return;
  }

  for( int i = 0; i < strlen(string); i++)
    if( string[i] == splitter)
      this->splittersCount++;

  this->splittersCount += 1;

  this->strings = new char*[this->splittersCount];
  assert (strings != NULL);

  int i = 0;
  int l = 0;

  if( this->splittersCount > 1)
  {
    const char* offset = string;
    char* end = strchr( string, splitter);
    while( end != NULL)
    {
      assert( i < this->splittersCount);
      l = end - offset;
      this->strings[i] = new char[l + 1];
      assert( strings[i] != NULL);
      strncpy( strings[i], offset, l);
      strings[i][l] = 0;
      i++;
      end++;
      offset = end;
      end = strchr( offset, splitter);
    }

    strings[i] = new char[l + 1];
    l = strlen( offset);
    strncpy( strings[i], offset, l);
    strings[i][l] = '\0';
  }
  else
  {
    this->strings[0] = new char[strlen(string)];
    strcpy(this->strings[0], string);
  }
}

/**
 *  removes the object from memory
*/
SubString::~SubString()
{
  if (this->strings)
  {
    for( int i = 0; i < this->splittersCount; i++)
      delete[] this->strings[i];
    delete[] this->strings;
  }
}

/**
 *  get a particular substring
 * @param i the ID of the substring to return
 * @returns the designated substring or NULL if an invalid ID was given
*/
const char* SubString::getString(unsigned int i)
{
  if( i < this->splittersCount && i >= 0)
    return this->strings[i];
  else
    return NULL;
}



/**
 * Some nice debug information about this SubString
 */
void SubString::debug() const
{
  PRINT(0)("Substring-information::count=%d ::", this->splittersCount);
  for (int i = 0; i < this->splittersCount; i++)
    PRINT(0)("s%d:%s::", i, this->strings[i]);
  PRINT(0)("\n");
}
