/*!
 * @file event_listener.h
  *  Definition of an event listener base class

*/

#ifndef _EVENT_LISTENER_H
#define _EVENT_LISTENER_H

#include "base_object.h"
#include "event.h"

//! A class for event listener
class EventListener : virtual public BaseObject {

 public:
  EventListener();
  virtual ~EventListener();

  /**
   *  abstract function that processes events from the handler
   * @param event: the event
  */
  virtual void process(const Event &event) = NULL;
};

#endif /* _EVENT_LISTENER_H */
