/*!
 * @file event.h
 * an abstract event
 *
 * @todo remove HUGE class-overhead. This could also be a struct
*/

#ifndef _EVENT_H
#define _EVENT_H


#include "base_object.h"
#include "sdlincl.h"

//! An abstract event class
class Event : virtual public BaseObject {

 public:
  Event();
  virtual ~Event();


  int      offset;                      //!< offset in the event type array
  int      type;                        //!< the type field
  bool     bPressed;                    //!< is true, if the button/mouse was pressed, false if released

  Uint16   x;                           //!< x coordinate
  Uint16   y;                           //!< y coordinate
  Sint16   xRel;                        //!< relative x movement to last point
  Sint16   yRel;                        //!< relative y movement to last point

  SDL_ResizeEvent resize;
};

#endif /* _EVENT_H */
