/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION

#include "cd_engine.h"
#include "obb_tree.h"
#include "debug.h"
#include "list.h"

#include "abstract_model.h"
#include "world_entity.h"
#include "terrain.h"
#include "player.h"

#include "spatial_separation.h"
#include "quadtree.h"
#include "quadtree_node.h"



using namespace std;


/**
 *  standard constructor
 */
CDEngine::CDEngine ()
{
  this->setClassID(CL_CD_ENGINE, "CDEngine");
}


/**
 *  the singleton reference to this class
 */
CDEngine* CDEngine::singletonRef = NULL;


/**
 *  standard deconstructor
 */
CDEngine::~CDEngine ()
{
  CDEngine::singletonRef = NULL;
}


/**
 *  this is the collision checking function

    there are some speed improvements that can be done here. a rewrite of the list a would be appropriate to
    be able to enhance iteration speed.
 */
void CDEngine::checkCollisions()
{
  this->checkCollisionObjects();
  //this->checkCollisionGround();
}

#include "class_list.h"
#include "state.h"
/**
 *  this checks the collisions with the objects
 */
void CDEngine::checkCollisionObjects()
{
  BVTree* tree;
  tIterator<WorldEntity>* iterator1 = entityList->getIterator();
  tIterator<WorldEntity>* iterator2 = entityList->getIterator();
  WorldEntity* entity1 = iterator1->firstElement();
  WorldEntity* entity2 = iterator2->iteratorElement(iterator1);
  PRINTF(3)("checking for collisions\n");
  while( entity1 != NULL)
  {
    if( likely(entity1 != this->terrain))
    {
      entity2 = iterator2->nextElement();

      while( entity2 != NULL)
      {
        if( likely(entity2 != this->terrain))
        {
          PRINTF(4)("checking object %s against %s\n", entity1->getName(), entity2->getName());
          tree = entity1->getOBBTree();
          if( likely(tree != NULL) && entity2->getOBBTree() != NULL) tree->collideWith(entity1, entity2);
        }
        entity2 = iterator2->nextElement();
      }
    }
    entity1 = iterator1->nextElement();
    entity2 = iterator2->iteratorElement(iterator1);
  }
  delete iterator1;
  delete iterator2;
}


/**
 *  this checks the collisions with the ground
 */
void CDEngine::checkCollisionGround()
{
  if( likely( this->terrain != NULL))
  {
    Quadtree* q = this->terrain->ssp->getQuadtree();

    QuadtreeNode* n = q->getQuadtreeFromPosition(this->player->getAbsCoor());
  }
  //sTriangleExt* tri = q->getTriangleFromPosition(this->player->getAbsCoor());
}


/**
 *  this draws the bounding volume tree
 * @param depth until which depth to draw the tree
 * @param drawMode mod which states how to draw it
 */
void CDEngine::drawBV(int depth, int drawMode) const
{
  /* this would operate on  worldList bases, for testing purposes, we only use one OBBTree */
  //this->rootTree->drawBV(depth, drawMode);

  tIterator<WorldEntity>* iterator = entityList->getIterator();
  WorldEntity* entity = iterator->firstElement();
  while( entity != NULL)
  {
    entity->drawBVTree(depth, drawMode);
    entity = iterator->nextElement();
  }
  delete iterator;
}


/**
 * some debug output on the class
 */
void CDEngine::debug()
{
  PRINT(0)("\n=============================| CDEngine::debug() |===\n");
  PRINT(0)("=  CDEngine: Spawning Tree Start\n");
  //this->rootTree->debug();
  PRINT(0)("=  CDEngine: Spawning Tree: Finished\n");
  PRINT(0)("=======================================================\n");

}


/**
 * this spawns a tree for debug purposes only
 */
void CDEngine::debugSpawnTree(int depth, sVec3D* vertices, int numVertices)
{
  if ( this->rootTree == NULL)
    this->rootTree = new OBBTree();
  this->rootTree->spawnBVTree(depth, vertices, numVertices);
}


/**
 * this draws the debug spawn tree
 */
void CDEngine::debugDraw(int depth, int drawMode)
{
  if(this-> rootTree != NULL)
    this->rootTree->drawBV(depth, drawMode);
}
