/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GARBAGE_COLLECTOR

#include "garbage_collector.h"

#include "state.h"
#include "world_entity.h"
#include "null_parent.h"

#include "list.h"

using namespace std;

GarbageCollector* GarbageCollector::singletonRef = 0;

/**
 *  standard constructor
*/
GarbageCollector::GarbageCollector ()
{
   this->setClassID(CL_GARBAGE_COLLECTOR, "GarbageCollector");
   this->setName("GarbageCollector");

   this->collectedObjects = NULL;
   this->unusedContainers = NULL;

   this->time = 0;
   this->delay = 5.0f; /* clean up all 5.0 seconds */
}


/**
 *  standard deconstructor
*/
GarbageCollector::~GarbageCollector ()
{
  // delete what has to be deleted here
}

/**
 *  this sets the collection delay
 * @param delay: the delay

   after this delay, the garbage collector starts its work and begins to collect unused object
   to delete them afterwards. only objects in the worldentity list from the world object are lookded
   at.
*/
void GarbageCollector::setCollectionDelay(float delay)
{
  this->delay = delay;
}


/**
 *  this foreces a garbage collection

   if this function is called, the gc tries to initiate the garbage collection routines. actually
   this should always work.
*/
void GarbageCollector::forceCollection()
{
  /* just make the time slitely bigger than the delay */
  this->time = this->delay + 1;
  /* and update, to get rid of the unused objects */
  this->update();
}


/**
 * collect an Object, that should be scheduled for clearing.
 * @param object the Object to schedule.
 */
void GarbageCollector::collect(BaseObject* object)
{
  State::getWorldEntityList()->remove(dynamic_cast<WorldEntity*>(object));
  FastObjectMember* tmpC;
  if (unlikely(this->unusedContainers == NULL))
  {
    tmpC = new FastObjectMember;
  }
  else
  {
    tmpC = this->unusedContainers;
    this->unusedContainers = this->unusedContainers->next;
  }

  tmpC->next = this->collectedObjects;
  tmpC->objectPointer = object;
  this->collectedObjects = tmpC;
}

/**
 *  this ticks the GarbageCollector to give it the time pulse
 * @param time: the time passed since last tick

   like every other tick function eg. worldentity
*/
void GarbageCollector::tick(float time)
{
  this->time += time;
}


void GarbageCollector::update()
{
  if (this->time < this->delay || this->collectedObjects == NULL)
    return;
  else
  {
    FastObjectMember* tmpC = this->collectedObjects;
    FastObjectMember* moveC;
    while (tmpC != NULL)
    {
      //WorldEntity* entity = dynamic_cast<WorldEntity*>(tmpC->objectPointer);
      //State::getWorldEntityList()->remove(entity);
      //entity->remove();
      FastFactory::kill(tmpC->objectPointer, true);

      moveC = tmpC->next;
      tmpC->next = this->unusedContainers;
      this->unusedContainers = tmpC;
      tmpC = moveC;
    }
    this->collectedObjects = NULL;
  }
}

/**
 *  this updated the gargabe collection, if the time is ready
*/
// void GarbageCollector::update()
// {
//   if( this->time < this->delay)
//     return;
//   /* garbage collect */
//   PRINTF(3)("=============================\n");
//   PRINTF(3)("Processing Garbage Collection\n");
//   PRINTF(3)("=============================\n");
//   int counter = 0;
//
//   tList<WorldEntity>* list = State::getWorldEntityList();
//
//   tIterator<WorldEntity>* iterator = list->getIterator();
//   WorldEntity* entity = iterator->firstElement();
//   while( entity != NULL)
//     {
//       if( entity->isFinalized())
//         {
//           PRINTF(4)("= finalizing object\n");
//           ++counter;
//
//           /* first remove out of entity list */
//           list->remove(entity);
//           /* second remove out of pnode tree */
//           entity->remove();
//           /* then finaly delete reference */
//           //delete entity;
//           //FastFactory::kill();
//           //ObjectManager::getInstance()->addToDeadList(entity->getClassID() & CL_MASK_LOWLEVEL_CLASS, entity);
//         }
//       entity = iterator->nextElement();
//     }
//
//   PRINTF(3)("= collected %i unused objects\n", counter);
//   PRINTF(3)("=============================\n");
//
//   //ObjectManager::getInstance()->debug();
//
//   /* reset time to count again up to this->delay */
//   this->time = 0;
// }
