/*!
 * @file event_handler.h
 * Definition of the EventHandler
 *
 */

#ifndef _EVENT_HANDLER_H
#define _EVENT_HANDLER_H

#include "base_object.h"
#include "key_mapper.h"
#include "event_def.h"

// FORWARD DECLARATION
class EventListener;
template <class T> class tList;
class IniParser;

//! The one Event Handler from Orxonox
class EventHandler : public BaseObject {

 public:
  virtual ~EventHandler();
  /** @returns a Pointer to the only object of this Class */
  inline static EventHandler* getInstance() { if (!singletonRef) singletonRef = new EventHandler();  return singletonRef; };
  void init(IniParser* iniParser);

  /** @param state: to which the event handler shall change */
  inline void setState(elState state) { this->state = state; };
  /** @returns the current state */
  inline elState getState() const { return this->state; };

  void subscribe(EventListener* el, elState state, int eventType);
  void unsubscribe(elState state, int eventType);
  void unsubscribe(EventListener* el, elState state = ES_ALL);
  void flush(elState state);

  void process();

  void debug() const;

 private:
  EventHandler();


 private:
  static EventHandler*       singletonRef;                  //!< the singleton reference

  EventListener***           listeners;                     //!< a list of registered listeners
  elState                    state;                         //!< the state of the event handlder
  KeyMapper*                 keyMapper;                     //!< reference to the key mapper
};

#endif /* _EVENT_HANDLER_H */
