

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/


#include "test_entity.h"
#include "stdincl.h"
#include "model.h"
#include "md2Model.h"
#include "obb_tree.h"

using namespace std;



TestEntity::TestEntity ()
{
  this->setClassID(CL_TEST_ENTITY, "TestEntity");

//   this->md2Model = new MD2Model("models/tris.md2", "models/tris.pcx");
 this->md2Model = new MD2Model("models/goblin.md2", "maps/goblin.bmp");
  this->obbTree = new OBBTree(15, (sVec3D*)this->md2Model->data->pVertices, this->md2Model->data->numVertices);

  this->md2Model->setAnim(STAND);
  this->md2Model->debug();
}


TestEntity::~TestEntity ()
{
  delete this->md2Model;
}


void  TestEntity::setAnim(int animationIndex)
{
  this->md2Model->setAnim(animationIndex);
}


void TestEntity::tick (float time)
{
  this->md2Model->tick(time);
}


void TestEntity::hit (WorldEntity* weapon, Vector* loc) {}


void TestEntity::destroy () {}


void TestEntity::collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags) {}


void TestEntity::draw ()
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];


  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  this->md2Model->draw();


  glPopMatrix();
}

