/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "shell.h"

#include "text_engine.h"
#include "list.h"

#include <stdarg.h>
#include <stdio.h>

using namespace std;


/**
 * standard constructor
 */
Shell::Shell ()
{
  this->setClassID(CL_SHELL, "Shell");
  this->setName("Shell");

  this->buffer = new tList<char>;

  this->textSize = 10;

  //this->bufferSize = 0;
  this->bufferText = NULL;
  this->setBufferSize(100);
  this->setBufferDisplaySize(10);

  this->inputLineText = TextEngine::getInstance()->createText("fonts/earth.ttf", 10, TEXT_DYNAMIC, 255, 0, 0);
  this->inputLineText->setText(NULL);

  //this->addBufferLineStatic("asjflksjdvklasmv %s", "doom");
  //TextEngine::getInstance()->debug();
  //exit(-1);
}

Shell* Shell::singletonRef = NULL;

/**
 * standard deconstructor
 */
Shell::~Shell ()
{
  // delete what has to be deleted here
  for (int i = 0; i < this->bufferDisplaySize; i++)
    delete this->bufferText[i];
  delete this->bufferText;
  delete this->inputLineText;

  Shell::singletonRef = NULL;
}

/**
 * sets The count of Lines to display in the buffer.
 * @param bufferDisplaySize the count of lines to display in the Shell-Buffer.
 */
void Shell::setBufferDisplaySize(unsigned int bufferDisplaySize)
{
  if (this->bufferText != NULL)
  {
    for (unsigned int i = 0; i < this->bufferDisplaySize; i++)
      delete this->bufferText[i];
    delete this->bufferText;
  }

  this->bufferText = new Text*[bufferDisplaySize];
  for (unsigned int i = 0; i < bufferDisplaySize; i++)
  {
    this->bufferText[i] = TextEngine::getInstance()->createText("fonts/earth.ttf", this->textSize, TEXT_DYNAMIC, 255, 0, 0);
    this->bufferText[i]->setAlignment(TEXT_ALIGN_LEFT);
    this->bufferText[i]->setPosition2D(5, 400 + 12*i);
    this->bufferText[i]->setText(NULL);
  }


  this->bufferDisplaySize = bufferDisplaySize;
}

/**
 * deletes all the Buffers
 */
void Shell::flushBuffers()
{
  // remove all chars from the BufferTexts.
  if (this->bufferText)
    for (int i; i < this->bufferDisplaySize; i++)
    {
      this->bufferText[i]->setText(NULL);
    }


  // delete all the Chars in the Buffers
  tIterator<char>* charIterator = this->buffer->getIterator();
  char* charElem = charIterator->nextElement();

  while (charElem != NULL)
  {
    delete charElem;

    charElem = charIterator->nextElement();
  }
  delete charIterator;
}

/**
 * adds a new Line to the List of Buffers
 * @param line the Line as in the first argument in printf
 * @param args the arguments as a va_list
 *
 * @todo optimize
 */
bool Shell::addBufferLineStatic(const char* line, ...)
{
  va_list arguments;
  va_start(arguments, line);

  if (Shell::singletonRef == NULL)
   vprintf(line, arguments);
  else
    Shell::singletonRef->addBufferLine(line, arguments);
  return true;
}
int curr = 0;

/**
 * add a Line to the List of Buffers
 * @param line
 * @param arguments
 *
 * This function Adds one line to the buffer.
 * and displays the line as the First Line of the display-buffer
 */
void Shell::addBufferLine(const char* line, va_list arguments)
{
   vsprintf(this->bufferArray, line, arguments);

   char* newLine = new char[strlen(this->bufferArray)+1];
   strcpy(newLine, this->bufferArray);

   this->buffer->add(newLine);

   if (this->buffer->getSize() > this->bufferSize)
   {
     delete this->buffer->firstElement();
     this->buffer->remove(this->buffer->firstElement());
   }

   if (likely(bufferText != NULL))
   {
     Text* moveText = this->bufferText[this->bufferDisplaySize-1];
     for (int i = this->bufferDisplaySize-1; i > 0; i--)
     {
       this->bufferText[i] = this->bufferText[i-1];
     }
     this->bufferText[0] = moveText;
   }
   this->bufferText[0]->setText(newLine);
   // this->bufferText->
//  this->inputLineText->setText(newLine);
}

/**
 * moves the buffer around lineCount lines upwards (negative values move down)
 * @param lineCount the Count of lines to move upwards
 *
 * @todo
 */
void Shell::moveBuffer(int lineCount)
{
}

/**
 * @param lineNumber the n-th line from the bottom
 * @returns the Buffer at Line lineNumber
 */
const char* Shell::getBufferLine(unsigned int lineNumber)
{
  tIterator<char>* charIterator = this->buffer->getIterator();
  char* charElem = charIterator->nextElement();

  int i = 1;
  while (charElem != NULL)
  {
    if (i++ < lineNumber)
    {
      delete charIterator;
      return charElem;
    }

    charElem = charIterator->nextElement();
  }
  delete charIterator;
}


/**
 * deletes the InputLine
 */
void Shell::flushInputLine()
{
  if (likely(this->inputLine != NULL))
  {
    delete [] this->inputLine;
  }
  this->inputLine = new char[1];
  *this->inputLine = '\0';

}

/**
 * adds one character to the inputLine
 * @param character the character to add to the inputLine
 */
void Shell::addCharacter(char character)
{
  char* addCharLine = new char[strlen(inputLine)+2];

  sprintf(addCharLine, "%s%c", this->inputLine, character);
  delete this->inputLine;
  this->inputLine = addCharLine;
}

/**
 * adds multiple Characters to thr inputLine
 * @param characters a '\0' terminated char-array to add to the InputLine
 */
void Shell::addCharacters(const char* characters)
{
  char* addCharLine = new char[strlen(inputLine)+strlen(characters)+1];

  sprintf(addCharLine, "%s%s", this->inputLine, characters);
  delete this->inputLine;
  this->inputLine = addCharLine;
}

/**
 * removes characterCount characters from the InputLine
 * @param characterCount the count of Characters to remove from the input Line
 */
void Shell::removeCharacters(unsigned int characterCount)
{
  if (characterCount > strlen(this->inputLine))
    characterCount = strlen(this->inputLine);

  char* removeCharLine = new char[strlen(inputLine)-characterCount+1];

  strncpy(removeCharLine, this->inputLine, strlen(inputLine)-characterCount);
  delete this->inputLine;
  this->inputLine = removeCharLine;
}

/**
 * listens for some event
 * @param event the Event happened
 */
void Shell::process(const Event &event)
{
//  if (event.type)

}

/**
 * ticks the Shell for dt Seconds
 * @param dt the elapsed time since the last tick();
 */
//void Shell::tick(float dt)
//{
//}

/**
 * displays the Shell
 */
void Shell::draw() const
{
}


/**
 * autocompletes the Shell's inputLine
 * @returns true, if a result was found, false otherwise
 */
bool Shell::autoComplete()
{

}

/**
 * displays some nice output from the Shell
 */
void Shell::debug() const
{

}
