

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:


   @todo: direction in which the projectile flights
   @todo: a target to set/hit
*/


#include "test_gun.h"

#include "world_entity.h"
#include "model.h"
#include "test_bullet.h"
#include "weapon_manager.h"

#include "state.h"
#include "vector.h"
#include "list.h"
#include "animation3d.h"
#include "sound_engine.h"

#include "null_parent.h"

#include "fast_factory.h"


using namespace std;

CREATE_FACTORY(TestGun);

/**
 *  standard constructor

   creates a new weapon
*/
TestGun::TestGun (WeaponManager* weaponManager, int leftRight)
  : Weapon(weaponManager)
{
  this->init();


  this->leftRight = leftRight;

  this->objectComponent1 = new PNode();
  Animation3D* animation1 = this->getAnimation(WS_SHOOTING, this->objectComponent1);
  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);
  //parent->addChild(this->objectComponent1, PNODE_ALL);
  this->addChild(this->objectComponent1, PNODE_ALL);

  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);

  if( this->leftRight == W_LEFT)
  {
    this->setEmissionPoint(1.0, 0.0, -0.35);

    animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
    animation1->addKeyFrame(Vector(-0.4, 0, 0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
    animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.0, ANIM_LINEAR, ANIM_CONSTANT);

    animation2->addKeyFrame(Vector(0.0, 0.0, -1.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
    animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

    animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
    animation3->addKeyFrame(Vector(0.0, 0.0, -1.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  }
  else if( this->leftRight == W_RIGHT)
  {
    this->setEmissionPoint(1.0, 0.0, 0.5);

    this->objectComponent1->setRelCoor(Vector(0,0,0.35));
    animation1->addKeyFrame(Vector(0, 0, .5), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
    animation1->addKeyFrame(Vector(-0.4, 0, .5), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
    animation1->addKeyFrame(Vector(0, 0, .5), Quaternion(), 0.0, ANIM_LINEAR, ANIM_CONSTANT);

    animation2->addKeyFrame(Vector(.0, .0, 1.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
    animation2->addKeyFrame(Vector(.0, .0, .0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

    animation3->addKeyFrame(Vector(.0, .0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
    animation3->addKeyFrame(Vector(.0, .0, 1.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  }
}


TestGun::TestGun(const TiXmlElement* root)
{
  this->init();
  this->loadParams(root);
}

/**
 *  standard deconstructor
*/
TestGun::~TestGun ()
{
  // model will be deleted from WorldEntity-destructor
}


void TestGun::init()
{
  this->setClassID(CL_TEST_GUN, "TestGun");

//  this->model = (Model*)ResourceManager::getInstance()->load("models/guns/test_gun.obj", OBJ, RP_CAMPAIGN);

  this->loadModel("models/guns/test_gun.obj");

  this->setStateDuration(WS_SHOOTING, .3);
  this->setStateDuration(WS_RELOADING, .5);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setMaximumEnergy(1000, 100);
  this->increaseEnergy(1000);
  //this->minCharge = 2;

  this->setActionSound(WA_SHOOT, "sound/shot1.wav");

  this->setProjectile(CL_TEST_BULLET);
  this->getProjectileFactory()->prepare(20);
}


void TestGun::loadParams(const TiXmlElement* root)
{


}


/**
 *  this activates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void TestGun::activate()
{
}


/**
 *  this deactivates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void TestGun::deactivate()
{
}


/**
 *  fires the weapon

   this is called from the player.cc, when fire-button is been pushed
   @todo: the ObjectManager deliveres Projectiles not TestBullets! this should be diffrent
*/
void TestGun::fire()
{
  Projectile* pj =  dynamic_cast<Projectile*>(this->getProjectileFactory()->resurrect());

  pj->setParent(NullParent::getInstance());

  pj->setVelocity(this->getVelocity() + this->getAbsDir().apply(Vector(1,0,0))*20);

  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  State::getWorldEntityList()->add(pj);
}


/**
 *  is called, when the weapon gets hit (=collide with something)
 * @param from which entity it is been hit
 * @param where it is been hit

   this may not be used, since it would make the game relay complicated when one
   can destroy the weapons of enemies or vice versa.
*/
void TestGun::hit (WorldEntity* entity, Vector* position)
{}


/**
 *  is called, when the weapon is destroyed

   this is in conjunction with the hit function, so when a weapon is able to get
   hit, it can also be destoryed.
*/
void TestGun::destroy ()
{}

/**
 *  this will draw the weapon
*/
void TestGun::draw ()
{
  /* draw gun body */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);

  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  if( this->leftRight == W_RIGHT)
    glScalef(1.0, 1.0, -1.0);
  this->model->draw(1);
  glPopMatrix();

  /* draw objectComponent1: gun coil - animated stuff */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->objectComponent1->getAbsCoor ().x,
                this->objectComponent1->getAbsCoor ().y,
                this->objectComponent1->getAbsCoor ().z);
  tmpRot = this->objectComponent1->getAbsDir().getSpacialAxis();
  glRotatef (this->objectComponent1->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
  this->model->draw(0);
  glPopMatrix();
}

