

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/


//#include "ai.h"

#include "npc.h"
#include "obb_tree.h"

#include "state.h"


using namespace std;


NPC::NPC()
{
  this->setClassID(CL_NPC, "NPC");

  this->loadModel("models/ships/bolido.obj");
  if(this->obbTree == NULL)
    this->obbTree = new OBBTree(4, (sVec3D*)this->model->getVertexArray(), this->model->getVertexCount());
}


NPC::~NPC () {}


void NPC::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (entity->isA(CL_PROJECTILE))
    PRINTF(0)("collision %s vs %s @ (%f,%f,%f)\n", this->getName(), entity->getName(), location.x, location.y, location.z);
}


void NPC::tick(float dt)
{
  Vector direction = (State::getCameraTarget()->getAbsCoor() - this->getAbsCoor());

  //if (directin.len() < 100)
  this->shiftCoor(direction *dt * 5 * exp(-direction.len()/30.0));

}



