/*!
 * @file ini_parser.h
 * A small ini file parser
 *
 * Can be used to find a defined [Section] in an ini file and get the VarName = Value entries
 */

#ifndef _INI_PARSER_H
#define _INI_PARSER_H

#define PARSELINELENGHT     512       //!< how many chars to read at once

#include "base_object.h"

// FORWARD DEFINITION //
template<class T> class tList;

//! ini-file parser
/**
 * This class can be used to load an initializer file and parse it's contents for variablename=value pairs.
 */
class IniParser : public BaseObject
{
  private:
    ////////////////////////////////////
    struct IniEntry
    {
      char*              name;
      char*              value;
    };

    struct IniSection
    {
      char*               name;
      tList<IniEntry>*    entries;
    };
    ////////////////////////////////////

  public:
    IniParser (const char* filename = NULL);
    ~IniParser ();

    bool openFile(const char* name);

    bool getSection( const char* sectionName);
    const char* nextSection();

    bool isOpen() const { return (sections != NULL)?true:false; };

    const char* getVar(const char* entryName, const char* sectionName, const char* defaultValue = "") const;
    bool nextVar();

    const char* getCurrentName() const { return (currentEntry!=NULL)?currentEntry->name:NULL; };
    const char* getCurrentValue() const { return (currentEntry!=NULL)?currentEntry->value:NULL; };

    void debug() const;

  private:
    void deleteSections();

  private:
    tList<IniSection>*    sections;
    IniSection*           currentSection;
    IniEntry*             currentEntry;
};

#endif /* _INI_PARSER_H */
