--register classes
thisscript:registerClass("Explosion")
-- Get objects from orxonox
thisscript:addObject("SpaceShip", "Player")
thisscript:addObject("CameraMan", "cameraManager")
thisscript:addObjectAsName("GameWorld", "Mission 1", "gameWorld")

triggerFadeOut = SpaceTrigger()
triggerFadeOut:setScript("vs1.lua")
triggerFadeOut:setFunction("explodeSpaceship")
triggerFadeOut:setRadius(380)
triggerFadeOut:setTarget("Player")
triggerFadeOut:setAbsCoor(3610, 116, -656)
triggerFadeOut:setDebugDraw(true)

triggerSwitchCam = SpaceTrigger()
triggerSwitchCam:setScript("vs1.lua")
triggerSwitchCam:setFunction("switchCam")
triggerSwitchCam:setRadius(400)
triggerSwitchCam:setTarget("Player")
triggerSwitchCam:setAbsCoor(3610, 116, -656)
triggerSwitchCam:setDebugDraw(true)

triggerEndLevel = TimeTrigger()
triggerEndLevel:setScript("vs1.lua")
triggerEndLevel:setFunction("changeLevel")
triggerEndLevel:setDelay(5)

--initialisation
explosion = Explosion()
explosion:setExplosionSound("sounds/explosions/explosion_6_BIG.wav")
cameraManager:changeTarget("cameraOne","SpaceShip", "Player")

-- globals
boomSize = 25


function changeLevel(timestep)
  gameWorld:setNextStoryName("Moonstation")
  gameWorld:stop()
  return true
end


function explodeSpaceship(timestep)
	explosion:setAbsCoor(Player:getAbsCoorX(),Player:getAbsCoorY(),Player:getAbsCoorZ())
	explosion:explode(boomSize,boomSize,boomSize)
	boomSize = boomSize + 4
	if boomSize > 75 then
 		  triggerEndLevel:start()
		  cameraManager:toggleFade()
		  gameWorld:showText("We have been hit...")
		  gameWorld:showText("Initialising emergency sequence!")
		return true
	end
	return false
end

function switchCam(timestep)
cameraManager:setCam("cameraOne")
return true
end
