

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:


   @todo: direction in which the projectile flights
   @todo: a target to set/hit
*/


#include "test_gun.h"

#include "world_entity.h"
#include "model.h"
#include "test_bullet.h"

#include "state.h"
#include "vector.h"
#include "list.h"
#include "animation3d.h"
#include "sound_engine.h"

#include "object_manager.h"

using namespace std;


/**
 *  standard constructor

   creates a new weapon
*/
TestGun::TestGun (PNode* parent, const Vector& coordinate,
                  const Quaternion& direction, int leftRight)
  :  Weapon (parent, coordinate, direction)
{
  this->setClassID(CL_TEST_GUN, "TestGun");

  this->model = (Model*)ResourceManager::getInstance()->load("models/test_gun.obj", OBJ, RP_CAMPAIGN);
  this->leftRight = leftRight;

  this->objectComponent1 = new PNode();
  this->animation1 = new Animation3D(this->objectComponent1);
  this->animation2 = new Animation3D(this);
  this->animation3 = new Animation3D(this);
  //parent->addChild(this->objectComponent1, PNODE_ALL);
  this->addChild(this->objectComponent1, PNODE_ALL);

  this->animation1->setInfinity(ANIM_INF_CONSTANT);
  this->animation2->setInfinity(ANIM_INF_CONSTANT);
  this->animation3->setInfinity(ANIM_INF_CONSTANT);
  if( this->leftRight == W_LEFT)
    {
      this->projectileOffset = Vector(1.0, 0.0, -0.35);

      this->animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
      this->animation1->addKeyFrame(Vector(-0.4, 0, 0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
      this->animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.0, ANIM_LINEAR, ANIM_CONSTANT);

      this->animation2->addKeyFrame(Vector(-2.6, 0.1, 2.0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
      this->animation2->addKeyFrame(Vector(-2.6, 0.1, 3.0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);

      this->animation3->addKeyFrame(Vector(-2.6, 0.1, 3.0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
      this->animation3->addKeyFrame(Vector(-2.6, 0.1, 2.0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
    }
  else if( this->leftRight == W_RIGHT)
    {
      this->projectileOffset = Vector(1.0, 0.0, 0.5);

      this->objectComponent1->setRelCoor(Vector(0,0,0.35));
      this->animation1->addKeyFrame(Vector(0, 0, .5), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
      this->animation1->addKeyFrame(Vector(-0.4, 0, .5), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
      this->animation1->addKeyFrame(Vector(0, 0, .5), Quaternion(), 0.0, ANIM_LINEAR, ANIM_CONSTANT);

      this->animation2->addKeyFrame(Vector(-2.6, 0.1, -2.0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
      this->animation2->addKeyFrame(Vector(-2.6, 0.1, -3.0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);

      this->animation3->addKeyFrame(Vector(-2.6, 0.1, -3.0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
      this->animation3->addKeyFrame(Vector(-2.6, 0.1, -2.0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_CONSTANT);
    }
/*
  this->fireSound = (SoundBuffer*)ResourceManager::getInstance()->load("sound/shot1.wav", WAV);
  this->weaponSource = new SoundSource(this->fireSound, this);
  this->weaponSource->setRolloffFactor(.1);*/
  Projectile* p = new TestBullet(this);
//  ObjectManager::getInstance()->cache(CL_TEST_BULLET, 100, p);
  //ObjectManager::getInstance()->debug();

  this->setStateDuration(WS_SHOOTING, 2);

  this->energy = 100;
  this->minCharge = 2;
}


/**
 *  standard deconstructor
*/
TestGun::~TestGun ()
{
  // model will be deleted from WorldEntity-destructor
}


/**
 *  this activates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void TestGun::activate()
{
  this->animation2->replay();
}


/**
 *  this deactivates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void TestGun::deactivate()
{
  this->animation3->replay();
}


/**
 *  fires the weapon

   this is called from the player.cc, when fire-button is been pushed
   @todo: the ObjectManager deliveres Projectiles not TestBullets! this should be diffrent
*/
void TestGun::fire()
{
  this->energyLoaded -= this->minCharge;

  Projectile* pj =  new TestBullet(this);//dynamic_cast<Projectile*>(ObjectManager::getInstance()->getFromDeadList(CL_TEST_BULLET & CL_MASK_LOWLEVEL_CLASS));
//  weaponSource->play();

  pj->setAbsCoor(this->getAbsCoor() + this->projectileOffset);
  pj->setAbsDir(this->getAbsDir());
  pj->setVelocity(this->getVelocity());
  State::getWorldEntityList()->add(pj);

  this->animation1->replay();
}


/**
 *  is called, when the weapon gets hit (=collide with something)
 * @param from which entity it is been hit
 * @param where it is been hit

   this may not be used, since it would make the game relay complicated when one
   can destroy the weapons of enemies or vice versa.
*/
void TestGun::hit (WorldEntity* entity, Vector* position)
{}


/**
 *  is called, when the weapon is destroyed

   this is in conjunction with the hit function, so when a weapon is able to get
   hit, it can also be destoryed.
*/
void TestGun::destroy ()
{}


/**
 *  is called, when there is no fire button pressed
*/
void TestGun::weaponIdle()
{}


/**
 *  this will draw the weapon
*/
void TestGun::draw ()
{
  /* draw gun body */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  this->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);
  if( this->leftRight == W_RIGHT)
    glScalef(1.0, 1.0, -1.0);
  this->model->draw(1);
  glPopMatrix();

  /* draw objectComponent1: gun coil - animated stuff */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->objectComponent1->getAbsCoor ().x,
                this->objectComponent1->getAbsCoor ().y,
                this->objectComponent1->getAbsCoor ().z);
  this->objectComponent1->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);
  this->model->draw(0);
  glPopMatrix();
}

