/*!
    \file spatial_separation.h  Definition of the generic spatial separation process of model data
 */

#ifndef _SPATIAL_SEPARATION_H
#define _SPATIAL_SEPARATION_H

#include "base_object.h"
#include "vector.h"


class AbstractModel;
class Quadtree;


#define SEC_OFFSET 1.0                       //!< the offset added to the overlapSize to ensure that there are no problems in



//! A class for spatial separation of vertices based arrays
class SpatialSeparation : public BaseObject {

  public:
    SpatialSeparation(AbstractModel* model, float overlapSize);
    SpatialSeparation(AbstractModel* model, AbstractModel* playerModel);
    virtual ~SpatialSeparation();

    void setTreeDepth(int depth) { this->treeDepth = depth; }
    void setMinLength(int minLength) { this->minLength = minLength; }

    Quadtree* createQuadtree(AbstractModel* model, float minLength);
    Quadtree* createQuadtree(AbstractModel* model, int treeDepth);
    Quadtree* createQuadtree(AbstractModel* model);


  private:
    void separateZone();


  private:
    AbstractModel*             model;        //!< the reference to the model that has to be handled
    Quadtree*                  quadtree;     //!< the reference to the created quadtree

    AbstractModel*             playerModel;  //!< referece to the player model, if needed for overlap calculations
    float                      overlapSize;  //!< the size of overlaping

    int                        treeDepth;    //!< depth of the quadtree
    float                      minLength;    //!< min length of a quadtree node
};

#endif /* _SPATIAL_SEPARATION_H */
