/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_SPATIAL_SEPARATION

#include "spatial_separation.h"
#include "abstract_model.h"
#include "quadtree.h"

using namespace std;


/**
 *  standard constructor
 * @param model the model that is to be separated
 * @param overlapSize each box will overlap for a given size

   The boxes are overlaping because this makes collision detection a lot simpler

*/
SpatialSeparation::SpatialSeparation (AbstractModel* model, float overlapSize)
{
   this->setClassID(CL_SPATIAL_SEPARATION, "SpatialSeparation");
   this->createQuadtree(model);
}

/**
 *  standard constructor
 * @param model the model that is to be separated
 * @param overlapSize each box will overlap for a given size

   The boxes are overlaping because this makes collision detection a lot simpler

 */
SpatialSeparation::SpatialSeparation (AbstractModel* model, AbstractModel* playerModel)
{
  this->setClassID(CL_SPATIAL_SEPARATION, "SpatialSeparation");

}


/**
 *  standard deconstructor

*/
SpatialSeparation::~SpatialSeparation ()
{
}


/**
  \brief creates a quadtree
* @param model the model to do a quadtree on
* @param minLength the minimal length of a quadtree node
  \return the new quadtree
 */
Quadtree* SpatialSeparation::createQuadtree(AbstractModel* model, float minLength)
{
  this->minLength = minLength;

}


/**
  \brief creates a quadtree
* @param model the model to do a quadtree on
* @param minLength the minimal length of a quadtree node
  \return the new quadtree
 */
Quadtree* SpatialSeparation::createQuadtree(AbstractModel* model, int treeDepth)
{
  this->treeDepth = treeDepth;
}


/**
  \brief creates a quadtree
* @param model the model to do a quadtree on
* @param minLength the minimal length of a quadtree node
  \return the new quadtree
*/
Quadtree* SpatialSeparation::createQuadtree(AbstractModel* model)
{
  this->quadtree = new Quadtree(model->getModelInfo());
  this->quadtree->separate();


  return this->quadtree;
}





















