/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_SPATIAL_SEPARATION

#include "quadtree_node.h"

using namespace std;


/**
 *  standard constructor
*/
QuadtreeNode::QuadtreeNode (sTriangleExt* triangles, int numTriangles, Quadtree* quadtree)
{
   this->setClassID(CL_QUADTREE_NODE, "QuadtreeNode");
}


/**
 *  standard constructor
 */
QuadtreeNode::QuadtreeNode(modelInfo* pModelInfo)
{
  this->pModelInfo = pModelInfo;
  this->getDimension(this->pModelInfo);
}


/**
 *  standard deconstructor

*/
QuadtreeNode::~QuadtreeNode ()
{
}



/**
 *  gives the signal to separate the model into a quadtree
 * @param treeDepth the max depth, the steps to go if treeDept == 0 leaf reached
 */
void QuadtreeNode::separateNode(int treeDepth)
{}


/**
 *  gives the signal to separate the model into a quadtree
 * @param treeDepth the max depth, the steps to go if treeDept == 0 leaf reached
*/
void QuadtreeNode::separateNode(float minLength)
{}


/**
 *  draws the debug quadtree boxes around the model
 */
void QuadtreeNode::drawTree(int depth, int drawMode) const
{}



/**
  \brief gets the maximal dimension of a model
 * @param playerModel the model that this measurement is based on
    \return the dimension of the AbstractModel as a Rectangle

    The rectangle is x-z axis aligned. ATTENTION: if there are any vertices in the model, that exceed the
    size of 999999.0, there probably will be some errors in the dimensions calculations.
 */
Rectangle* QuadtreeNode::getDimension(modelInfo* pModelInfo)
{
  float            maxX, maxY;                       //!< the maximal coordinates axis
  float            minX, minY;                       //!< minimal axis coorindates
  const float*     pVertices;                        //!< pointer to the current vertices

  maxX = -999999; maxY = -999999;
  minX =  999999; minY =  999999;
  /* get maximal/minimal x/y */
  for( int i = 0; i < pModelInfo->numVertices; ++i)
  {
    pVertices = &pModelInfo->pVertices[i * 3];
    if( pVertices[0] > maxX)
      maxX = pVertices[0];
    if( pVertices[2] > maxY)
      maxY = pVertices[2];

    if( pVertices[0] < minX)
      minX = pVertices[0];
    if( pVertices[2] < minY)
      minY = pVertices[2];
  }

  Rectangle* rect = new Rectangle();
  rect->setCenter((maxX + minX) / 2.0f, 0.0f, (maxY + minY) / 2.0f); /* this is little strange, since y is in opengl the up vector */
  rect->setAxis(fmax(((fabs(maxX) + fabs(minX)) / 2.0f), ((fabs(maxY) + fabs(minY)) / 2.0f)));

  PRINTF(0)("Dimension Informationation: X: min/max %f/%f Y: min/max %f/%f\n", minX, maxX, minY, maxY);
  return rect;
}

