/*!
    \file quadtree.h
  *  Definition of a spatial data separation using quadtree

*/

#ifndef _QUADTREE_H
#define _QUADTREE_H


#include "base_object.h"
#include "abstract_model.h"

class QuadtreeNode;

//! A class for quadtree separation of the world
class Quadtree : public BaseObject {

 public:
  Quadtree(modelInfo* pModelInfo);
  virtual ~Quadtree();

  void separate();

  void drawTree(int depth, int drawMode) const;

 private:
   QuadtreeNode*                   rootNode;              //!< reference to the root node of the quadtree
   modelInfo*                      pModelInfo;            //!< reference to the modelInfo of the object

};

#endif /* _QUADTREE_H */
