/*!
    \file player.h
    \brief Implements a basic controllable WorldEntity
 */

#ifndef _PLAYER_H
#define _PLAYER_H

#include "world_entity.h"
#include "physics_interface.h"
#include "event_listener.h"

template<class T> class tList;
class Weapon;
class WeaponManager;
class Vector;
class World;
class Event;
class Crosshair;

//! Basic controllable WorldEntity
class Player : public WorldEntity, public PhysicsInterface, public EventListener
{
  friend class World;

  public:
    Player();
    Player(const TiXmlElement* root);
    virtual ~Player();

    void init();
    void loadParams(const TiXmlElement* root);

    void addWeapon(Weapon* weapon);
    void removeWeapon(Weapon* weapon);

    virtual void postSpawn();
    virtual void leftWorld();
    virtual void hit(WorldEntity* weapon, Vector* loc);
    virtual void collide(WorldEntity* other, Uint32 ownhitflags, Uint32 otherhitflags);

    virtual void tick(float time);
    virtual void draw();

    virtual void command(Command* cmd);

    virtual void process(const Event &event);


  private:
    void move(float time);
    void weapon();


  private:
    bool bUp;              //!< up button pressed.
    bool bDown;            //!< down button pressed.
    bool bLeft;            //!< left button pressed.
    bool bRight;           //!< right button pressed.
    bool bAscend;          //!< ascend button pressed.
    bool bDescend;         //!< descend button presses.
    bool bFire;            //!< fire button pressed.
    bool bWeaponChange;    //!< weapon change button pressed

    tList<Weapon>* weapons;//!< a list of weapon
    Weapon* activeWeapon;  //!< the weapon that is currenty activated
    Weapon* activeWeaponL;  //temporary -- FIX THIS
    WeaponManager* weaponMan; //!< the weapon manager: managing a list of weapon to wepaon-slot mapping

    World* myWorld;        //!< reference to the world object

    Vector* velocity;       //!< the velocity of the player.
    float travelSpeed;     //!< the current speed of the player (to make soft movement)
    float acceleration;    //!< the acceleration of the player.

    Crosshair*  crosshair; //!< the crosshair of the player
};

#endif /* _PLAYER_H */
