/*!
    \file crosshair.h
    \brief Definition of ...

*/

#ifndef _CROSSHAIR_H
#define _CROSSHAIR_H

#include "event_listener.h"
#include "p_node.h"
#include "vector.h"

// FORWARD DEFINITION
class Model;
class Material;
class TiXmlElement;

//! A class that enables the
class Crosshair : public PNode, public EventListener {

 public:
  Crosshair(const TiXmlElement* root = NULL);
  virtual ~Crosshair();

  void init();
  void loadParams(const TiXmlElement* root);

  void setSize(float size);
  void setTexture(const char* textureFile);
  /** @param rotationSpeed the speed at what the crosshair should rotate */
  void setRotationSpeed(float rotationSpeed) { this->rotationSpeed = rotationSpeed; };

  virtual void process(const Event &event);
  void tick(float dt);
  void draw();

 private:
   float            position2D[2];        //!< The 2D-position on the screen

   Material*        material;             //!< a material for the Aim.
   float            rotation;             //!< a rotation of the aim.
   float            rotationSpeed;        //!< Speed of the Rotation.
   float            size;                 //!< The Size of the Crosshair (in % of screen resolution 1 is fullscreen)
};

#endif /* _CROSSHAIR_H */
