/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "crosshair.h"
#include "event_handler.h"

#include "load_param.h"
#include "graphics_engine.h"
#include "glincl.h"
#include "state.h"
#include "material.h"

#include <iostream>

using namespace std;


/**
 * standart constructor
 */
Crosshair::Crosshair (const TiXmlElement* root)
{
  this->init();

  if (root)
    this->loadParams(root);
  else
    this->setTexture("maps/aim.png");
}


/**
 * destroys a Crosshair
*/
Crosshair::~Crosshair ()
{
  if (this->material)
  delete this->material;

  // delete what has to be deleted here
  EventHandler::getInstance()->unsubscribe(this);

  GraphicsEngine::showMouse(true);
  GraphicsEngine::stealWMEvents(false);
}

/**
 * initializes the Crosshair
 */
void Crosshair::init()
{
  this->setClassID(CL_CROSSHAIR, "Crosshair");
  this->setName("Crosshair");

  this->rotation = 0;
  this->rotationSpeed = 5;
  this->setSize(GraphicsEngine::getInstance()->getResolutionX()/10.0);

  this->material = new Material;

  EventHandler::getInstance()->subscribe(this, ES_GAME, EV_MOUSE_MOTION);

  // center the mouse on the screen, and also hide the cursors
  SDL_WarpMouse(GraphicsEngine::getInstance()->getResolutionX()/2, GraphicsEngine::getInstance()->getResolutionY()/2);
  GraphicsEngine::showMouse(false);
  GraphicsEngine::stealWMEvents(true);
}


void Crosshair::loadParams(const TiXmlElement* root)
{
  static_cast<PNode*>(this)->loadParams(root);
  static_cast<EventListener*>(this)->loadParams(root);

  LoadParam<Crosshair>(root, "texture", this, &Crosshair::setTexture)
      .describe("the texture-file to load onto the Crosshair");

  LoadParam<Crosshair>(root, "size", this, &Crosshair::setSize)
      .describe("the size of the Crosshair in Pixels");

  LoadParam<Crosshair>(root, "rotation-speed", this, &Crosshair::setRotationSpeed)
      .describe("the Speed with which the Crosshair should rotate");
}


/**
 * sets the size of the Crosshair.
 * @param size the size in pixels
 */
void Crosshair::setSize(float size)
{
  this->size = size*.5;
};

/**
 * sets the material to load
 * @param textureFile The texture-file to load onto the crosshair
 */
void Crosshair::setTexture(const char* textureFile)
{
  this->material->setDiffuseMap(textureFile);
}

/**
 * processes the input
 * @param event the Event coming as input
 */
void Crosshair::process(const Event &event)
{
  if  (event.type == EV_MOUSE_MOTION)
  {
    this->position2D[0] = event.x;
    this->position2D[1] = event.y;
  }

  /*
  GLdouble z;
  GLdouble objX, objY, objZ;
  glReadPixels (event.x, event.y, 1, 1, GL_DEPTH_COMPONENT, GL_DOUBLE, &z);


  if (gluUnProject(event.x,
      event.y,
      10,
      GraphicsEngine::modMat,
      GraphicsEngine::projMat,
      GraphicsEngine::viewPort,
      &objX,
      &objY,
      &objZ ))
    PRINT(0)("screen %d %d -> obj(%f/%f/%f)\n", event.x, event.y, objX, objY, objZ);
  else
    PRINT(0)("shit\n");
*/
}

/**
 * ticks the Crosshair
 * @param dt the time to ticks
 */
void Crosshair::tick(float dt)
{
  this->rotation += dt * rotationSpeed;



}

/**
 * draws the crosshair
 */
void Crosshair::draw()
{
  /*
  const PNode* camera = State::getInstance()->getCamera();  //!< \todo MUST be different
  Vector cameraPos = camera->getAbsCoor();
  Vector cameraTargetPos = State::getInstance()->getCameraTarget()->getAbsCoor();
  Vector view = cameraTargetPos - cameraPos;
  Vector up = Vector(0, 1, 0);
  up = camera->getAbsDir().apply(up);
  Vector h = up.cross(view);
  Vector v = h.cross(view);
  h.normalize();
  v.normalize();

  float px = (position2D[0]-GraphicsEngine::getInstance()->getResolutionX()/2)*.05;
  float py = -(position2D[1]-GraphicsEngine::getInstance()->getResolutionY()/2)*.05;

  glBegin(GL_TRIANGLES);
  glVertex3f(cameraTargetPos.x - h.x*px - v.x*py,
  cameraTargetPos.y - h.y*px - v.y*py,
  cameraTargetPos.z - h.z*px - v.z*py);

  glVertex3f(cameraTargetPos.x - h.x*(px+1) - v.x*py,
  cameraTargetPos.y - h.y*(px+1) - v.y*py,
  cameraTargetPos.z - h.z*(px+1) - v.z*py);

  glVertex3f(cameraTargetPos.x - h.x*px - v.x*(py+1),
  cameraTargetPos.y - h.y*px - v.y*(py+1),
  cameraTargetPos.z - h.z*px - v.z*(py+1));

  glEnd();

  */


  GraphicsEngine::storeMatrices();

///  float z;
//   glReadPixels ((int)position2D[0], GraphicsEngine::getInstance()->getResolutionY()-(int)position2D[1]-1, 1, 1, GL_DEPTH_COMPONENT, GL_FLOAT, &z);


  //cout << z <<"  "<< scale << "  "  << bias<< endl;


  GLdouble objX, objY, objZ;
  gluUnProject(position2D[0],
               GraphicsEngine::getInstance()->getResolutionY()-position2D[1]-1,
               .99,
               GraphicsEngine::modMat,
               GraphicsEngine::projMat,
               GraphicsEngine::viewPort,
               &objX,
               &objY,
               &objZ );

  this->setAbsCoor(objX, objY, objZ);

//   glBegin(GL_TRIANGLES);
//   glColor3f(1,0,0);
//   glVertex3f(objX, objY, objZ);
//   glVertex3f(objX, objY+1, objZ);
//   glVertex3f(objX, objY, objZ+1);
//   glEnd();


  GraphicsEngine::enter2DMode();
  GLdouble pos[3];
  gluProject(this->getAbsCoor().x,
             this->getAbsCoor().y,
             this->getAbsCoor().z,
             GraphicsEngine::modMat,
             GraphicsEngine::projMat,
             GraphicsEngine::viewPort,
             pos, pos+1, pos+2 );


  glTranslatef(position2D[0], position2D[1], 0);
  glRotatef(this->rotation, 0,0,1);
  this->material->select();
  glBegin(GL_TRIANGLE_STRIP);
  glTexCoord2f(0, 0);
  glVertex2f(-size, -size);
  glTexCoord2f(1, 0);
  glVertex2f(size, -size);
  glTexCoord2f(0, 1);
  glVertex2f(-size, size);
  glTexCoord2f(1, 1);
  glVertex2f(size, size);
  glEnd();
  /*
  glBegin(GL_QUADS);
  {
    glColor4f(1,0,0,1);
    glVertex2f(position2D[0]-10, position2D[1]-10);
    glVertex2f(position2D[0]+10, position2D[1]-10);
    glVertex2f(position2D[0]+10, position2D[1]+10);
    glVertex2f(position2D[0]-10, position2D[1]+10);

    //     glVertex2f(pos[0]-10, pos[1]-10);
    //     glVertex2f(pos[0]-10, pos[1]+10);
    //     glVertex2f(pos[0]+10, pos[1]+10);
    //     glVertex2f(pos[0]+10, pos[1]-10);
  }
  glEnd();
  */
  GraphicsEngine::leave2DMode();
}
