
/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/

#include "weapon_manager.h"
#include "weapon.h"
#include "stdincl.h"
#include "world_entity.h"
#include "vector.h"
#include "model.h"
#include "projectile.h"
#include "list.h"
#include "world.h"

/**
   \brief standard constructor

   creates a new weapon
*/
Weapon::Weapon (PNode* parent, const Vector& coordinate, const Quaternion& direction)
  : WorldEntity()
{
  parent->addChild(this, PNODE_ALL);
  this->setRelCoor(coordinate);
  this->setRelDir(direction);
  WorldInterface* wi = WorldInterface::getInstance();
  this->worldEntities = wi->getEntityList();

  this->objectComponent1 = NULL;
  this->objectComponent2 = NULL;
  this->objectComponent3 = NULL;

  this->animation1 = NULL;
  this->animation2 = NULL;
  this->animation3 = NULL;
}


/**
   \brief standard deconstructor
*/
Weapon::~Weapon ()
{
  // model will be deleted from WorldEntity-destructor
  //this->worldEntities = NULL;

  /* dont delete objectComponentsX here, they will be killed when the pnodes are cleaned out */

  /* all animations are deleted via the animation player*/
}


/**
    \brief enables the weapon

    a weapon can be enabled/disabled because of various reasons. if a weapon is
    been enabled, it can interact in a world. elswhere it wont react to any
    action.
*/
void Weapon::enable()
{
  this->enabled = true;
}


/**
    \brief disables the weapon

    a weapon can be enabled/disabled because of various reasons. if a weapon is
    been enabled, it can interact in a world. elswhere it wont react to any
    action.
*/
void Weapon::disable()
{
  this->enabled = false;
}


/**
    \brief checks if the weapon is enabled
    \returns true if enabled

    a weapon can be ebabled/disabled because of various reasons. if a weapon is
    been enabled, it can interact in a world. elswhere it wont react to any
    action.
*/
bool Weapon::isEnabled()
{
  return this->enabled;
}


/**
   \brief sets a new projectile to the weapon
   \param new projectile for this weapon

   weapon an projectile are independent, so you can combine them as you want
*/
void Weapon::setProjectile(Projectile* projectile)
{
  this->projectile = projectile;
}


/**
   \brief sets a new projectile to the weapon
   \returns the current projectile of this weapon

   weapon an projectile are independent, so you can combine them as you want
*/
Projectile* Weapon::getProjectile()
{
  return this->projectile;
}


/**
   \brief this activates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void Weapon::activate()
{}


/**
   \brief this deactivates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void Weapon::deactivate()
{}

/**
   \brief asks if the current weapon is active
   \returns true if it the weapon is active
*/
bool Weapon::isActive()
{}






/**
   \brief is called, when the weapon gets hit (=collide with something)
   \param from which entity it is been hit
   \param where it is been hit

   this may not be used, since it would make the game relay complicated when one
   can destroy the weapons of enemies or vice versa.
*/
void Weapon::hit (WorldEntity* entity, Vector* position)
{}


/**
   \brief is called, when the weapon is destroyed

   this is in conjunction with the hit function, so when a weapon is able to get
   hit, it can also be destoryed.
*/
void Weapon::destroy ()
{}


/**
   \brief tick signal for time dependent/driven stuff
*/
void Weapon::tick (float time)
{}


/**
   \brief is called, when there is no fire button pressed
*/
void Weapon::weaponIdle()
{}


/**
   \brief this will draw the weapon
*/
void Weapon::draw ()
{}

